/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.test.backoff;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.anypoint.backoff.state.BackingOff;
import com.mulesoft.anypoint.backoff.state.BackingOn;
import com.mulesoft.anypoint.backoff.state.Error;
import com.mulesoft.anypoint.backoff.state.Stable;
import com.mulesoft.anypoint.backoff.state.State;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class BackoffStateTestCase {
    private BackoffConfiguration configuration;
    private SessionMetadata sessionMetadata;

    @Before
    public void before() {
        this.sessionMetadata = (SessionMetadata)Mockito.mock(SessionMetadata.class);
        this.configuration = new TestBackoffConfiguration();
    }

    @Test
    public void remainNoBacking() {
        Assert.assertThat((Object)this.stable(this.succeeds()).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.stable(this.succeeds())));
    }

    @Test
    public void looseNoBacking() {
        Assert.assertThat((Object)this.stable(this.fails()).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.off(this.succeeds(), 1)));
    }

    @Test
    public void returnToNoBacking() {
        Assert.assertThat((Object)this.on(this.succeeds(), 1).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.stable(this.succeeds())));
        Assert.assertThat((Object)this.off(this.succeeds(), 1).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.stable(this.succeeds())));
    }

    @Test
    public void changeFromOffToOn() {
        Assert.assertThat((Object)this.off(this.succeeds(), 12).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.on(this.succeeds(), 11)));
    }

    @Test
    public void changeFromOffToOnWithOverflowSteps() {
        this.configuration = new TestBackoffConfiguration(5, 12312);
        Assert.assertThat((Object)this.off(this.succeeds(), 12).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.on(this.succeeds(), 5)));
    }

    @Test
    public void remainBackingOff() {
        Assert.assertThat((Object)this.off(this.fails(), 23).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.off(this.succeeds(), 24)));
    }

    @Test
    public void remainBackingOffWithOverflowState() {
        this.configuration = new TestBackoffConfiguration(5, 10);
        Assert.assertThat((Object)this.off(this.fails(), 10).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.off(this.succeeds(), 10)));
    }

    @Test
    public void remainBackingOn() {
        Assert.assertThat((Object)this.on(this.succeeds(), 3).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.on(this.succeeds(), 2)));
    }

    @Test
    public void changeFromOnToOff() {
        Assert.assertThat((Object)this.on(this.fails(), 1).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.off(this.succeeds(), 1)));
        Assert.assertThat((Object)this.on(this.fails(), 23).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.off(this.succeeds(), 23)));
    }

    @Test
    public void noDelayWhenNoBacking() {
        Assert.assertThat((Object)new Stable(this.configuration, this.succeeds()).delay(), (Matcher)Matchers.is((Object)Period.seconds((int)0)));
    }

    @Test
    public void delayOnBackingOff() {
        this.configuration = new BackoffConfiguration.Builder(true).backoff(2.0, 1.0, 4, Function.identity()).build();
        State failOnce = this.stable(this.fails()).next(this.sessionMetadata);
        State failTwice = failOnce.next(this.sessionMetadata);
        State failThreeTimes = failTwice.next(this.sessionMetadata);
        State failFourTimes = failThreeTimes.next(this.sessionMetadata);
        State failFiveTimes = failFourTimes.next(this.sessionMetadata);
        Assert.assertThat((Object)failOnce.delay(), (Matcher)Matchers.is((Object)Period.seconds((int)2)));
        Assert.assertThat((Object)failTwice.delay(), (Matcher)Matchers.is((Object)Period.seconds((int)4)));
        Assert.assertThat((Object)failThreeTimes.delay(), (Matcher)Matchers.is((Object)Period.seconds((int)8)));
        Assert.assertThat((Object)failFourTimes.delay(), (Matcher)Matchers.is((Object)Period.seconds((int)16)));
        Assert.assertThat((Object)failFiveTimes.delay(), (Matcher)Matchers.is((Object)Period.seconds((int)16)));
    }

    @Test
    public void delayOnBackingOn() {
        this.configuration = new BackoffConfiguration.Builder(true).backon(3.0, 1.0, 3, Function.identity()).build();
        this.configuration = new BackoffConfiguration.Builder(true).backon(3.0, 1.0, 3, Function.identity()).build();
        State recoverOnce = this.off(this.succeeds(), 3).next(this.sessionMetadata);
        State recoverTwice = recoverOnce.next(this.sessionMetadata);
        State recoverThreeTimes = recoverTwice.next(this.sessionMetadata);
        State recoverFourTimes = recoverThreeTimes.next(this.sessionMetadata);
        Assert.assertThat((Object)recoverOnce.delay(), (Matcher)Matchers.is((Object)Period.seconds((int)9)));
        Assert.assertThat((Object)recoverTwice.delay(), (Matcher)Matchers.is((Object)Period.seconds((int)3)));
        Assert.assertThat((Object)recoverThreeTimes.delay(), (Matcher)Matchers.is((Object)Period.seconds((int)0)));
        Assert.assertThat((Object)recoverThreeTimes, (Matcher)Matchers.instanceOf(Stable.class));
        Assert.assertThat((Object)recoverFourTimes.delay(), (Matcher)Matchers.is((Object)Period.seconds((int)0)));
        Assert.assertThat((Object)recoverFourTimes, (Matcher)Matchers.instanceOf(Stable.class));
    }

    @Test
    public void noBackonForNonReschedulableTasks() {
        this.configuration = new BackoffConfiguration.Builder(true).fastRecovery().build();
        Assert.assertThat((Object)this.off(this.succeeds(), 10).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.stable(this.succeeds())));
    }

    @Test
    public void errorWhenStable() {
        Assert.assertThat((Object)this.stable(this.crashes()).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.error(this.succeeds(), 1)));
    }

    @Test
    public void errorWhenBackoff() {
        Assert.assertThat((Object)this.off(this.crashes(), 1).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.error(this.succeeds(), 2)));
        Assert.assertThat((Object)this.off(this.crashes(), 23).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.error(this.succeeds(), 24)));
    }

    @Test
    public void errorWhenBackon() {
        Assert.assertThat((Object)this.on(this.crashes(), 1).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.error(this.succeeds(), 2)));
        Assert.assertThat((Object)this.on(this.crashes(), 23).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.error(this.succeeds(), 24)));
    }

    @Test
    public void errorWhenError() {
        Assert.assertThat((Object)this.error(this.crashes(), 1).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.error(this.succeeds(), 2)));
        Assert.assertThat((Object)this.error(this.crashes(), 23).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.error(this.succeeds(), 24)));
    }

    @Test
    public void remainErrorDespiteOutcomeOnFastRecovery() {
        this.configuration = new BackoffConfiguration.Builder(true).fastRecovery().build();
        Assert.assertThat((Object)this.error(this.succeeds(), 1).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.error(this.succeeds(), 2)));
        Assert.assertThat((Object)this.error(this.fails(), 1).next(this.sessionMetadata), (Matcher)Matchers.is((Object)this.error(this.succeeds(), 2)));
    }

    protected State stable(BackoffBarrier backoffBarrier) {
        return new Stable(this.configuration, backoffBarrier);
    }

    protected State off(BackoffBarrier backoffBarrier, int steps) {
        return new BackingOff(this.configuration, backoffBarrier, steps);
    }

    protected State on(BackoffBarrier backoffBarrier, int steps) {
        return new BackingOn(this.configuration, backoffBarrier, steps);
    }

    protected State error(BackoffBarrier backoffBarrier, int steps) {
        return new Error(this.configuration, backoffBarrier, steps);
    }

    private BackoffBarrier succeeds() {
        return this.action(false, false);
    }

    private FakeMetadataProcessor fails() {
        return this.action(true, false);
    }

    private FakeMetadataProcessor crashes() {
        return this.action(true, true);
    }

    private FakeMetadataProcessor action(boolean endpointFails, boolean fatalError) {
        return new FakeMetadataProcessor(endpointFails, fatalError);
    }

    private class TestBackoffConfiguration
    extends BackoffConfiguration {
        private final int backonSteps;
        private final int backoffSteps;

        private TestBackoffConfiguration() {
            this(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        private TestBackoffConfiguration(int backonSteps, int backoffSteps) {
            super(new BackoffConfiguration.Builder(true));
            this.backonSteps = backonSteps;
            this.backoffSteps = backoffSteps;
        }

        public int backoffSteps() {
            return this.backoffSteps;
        }

        public int backonSteps() {
            return this.backonSteps;
        }
    }

    private class FakeMetadataProcessor
    implements BackoffBarrier {
        private final boolean endpointFails;
        private final boolean fatalError;

        public FakeMetadataProcessor(boolean endpointFails, boolean fatalError) {
            this.endpointFails = endpointFails;
            this.fatalError = fatalError;
        }

        public boolean shouldBackoff(SessionMetadata sessionMetadata, BackoffConfiguration configuration) {
            return this.endpointFails;
        }

        public boolean gotError(SessionMetadata sessionMetadata) {
            return this.fatalError;
        }
    }
}

