/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.test.backoff;

import com.mulesoft.anypoint.backoff.function.BoundedExponentialFunction;
import com.mulesoft.anypoint.backoff.function.Round;
import com.mulesoft.anypoint.backoff.function.dispersion.RangeDispersant;
import com.mulesoft.anypoint.test.backoff.mocks.ControlledDispersant;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;

public class ExponentialFunctionTestCase {
    private ControlledDispersant dispersant;

    @Before
    public void setUp() {
        this.dispersant = new ControlledDispersant();
    }

    @Test
    public void limitedExponentialFunction() {
        Function<Integer, Double> expBoundedTo4 = this.exp(2.0, 0, 2, 1.0);
        MatcherAssert.assertThat((Object)expBoundedTo4.apply(0), (Matcher)Is.is((Object)1.0));
        MatcherAssert.assertThat((Object)expBoundedTo4.apply(-1), (Matcher)Is.is((Object)1.0));
        MatcherAssert.assertThat((Object)expBoundedTo4.apply(1), (Matcher)Is.is((Object)2.0));
        MatcherAssert.assertThat((Object)expBoundedTo4.apply(2), (Matcher)Is.is((Object)4.0));
        MatcherAssert.assertThat((Object)expBoundedTo4.apply(3), (Matcher)Is.is((Object)4.0));
    }

    @Test
    public void scaledExponentialFunction() {
        Function<Integer, Double> expTimes10 = this.exp(2.0, 0, 2, 10.0);
        Function<Integer, Double> expTimesZero = this.exp(2.0, 0, 2, 0.0);
        MatcherAssert.assertThat((Object)expTimes10.apply(0), (Matcher)Is.is((Object)10.0));
        MatcherAssert.assertThat((Object)expTimes10.apply(-1), (Matcher)Is.is((Object)10.0));
        MatcherAssert.assertThat((Object)expTimes10.apply(1), (Matcher)Is.is((Object)20.0));
        MatcherAssert.assertThat((Object)expTimes10.apply(2), (Matcher)Is.is((Object)40.0));
        MatcherAssert.assertThat((Object)expTimes10.apply(3), (Matcher)Is.is((Object)40.0));
        MatcherAssert.assertThat((Object)expTimesZero.apply(3), (Matcher)Is.is((Object)0.0));
    }

    @Test
    public void scalingNegative() {
        MatcherAssert.assertThat((Object)this.exp(2.0, 0, 2, -10.0).apply(0), (Matcher)Is.is((Object)-10.0));
        MatcherAssert.assertThat((Object)this.exp(-2.0, 0, 2, -10.0).apply(0), (Matcher)Is.is((Object)-10.0));
        MatcherAssert.assertThat((Object)this.exp(-2.0, 0, 2, -10.0).apply(1), (Matcher)Is.is((Object)20.0));
    }

    @Test
    public void dispersion() {
        IntStream.range(0, 1000).forEach(i -> MatcherAssert.assertThat((String)("Failed in iteration: " + i), (Object)this.dispersantExp(2.0, 0, 2, 1.0).apply(2), (Matcher)Is.is((Object)this.exp(2.0, 0, 2, this.dispersant.lastMultiplier()).apply(2))));
    }

    @Test
    public void rangeDispersant() {
        double value = 10.0;
        ArrayList dispersedValues = new ArrayList();
        IntStream.range(0, 10000).forEach(i -> {
            Double dipersedValue = new RangeDispersant(0.5, 1.0).apply(Double.valueOf(value));
            MatcherAssert.assertThat((String)("Failed in iteration" + i), (Object)dipersedValue, this.isBetween(5.0, 10.0));
            dispersedValues.add(dipersedValue);
        });
        MatcherAssert.assertThat(dispersedValues, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.hasItem((Matcher)Matchers.not((Object)value))}));
    }

    @Test
    public void roundedFunction() {
        Round roundingFunction = new Round((Function)new BoundedExponentialFunction(2.0, 0, 2, 1.5));
        MatcherAssert.assertThat((Object)((Integer)roundingFunction.apply(0)), (Matcher)Is.is((Object)2));
    }

    private Function<Integer, Double> exp(double base, int minExponent, int maxExponent, double multiplier) {
        return new BoundedExponentialFunction(base, minExponent, maxExponent, multiplier);
    }

    private Function<Integer, Double> dispersantExp(double base, int minExponent, int maxExponent, double multiplier) {
        return new BoundedExponentialFunction(base, minExponent, maxExponent, multiplier, (Function)this.dispersant);
    }

    private Matcher<Double> isBetween(double min, double max) {
        return Is.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(min)), Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(max))}));
    }
}

