/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.test.backoff.engine;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.test.backoff.engine.Range;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BackoffSimulation {
    private final Period delay;
    private final Period frequency;
    private final BackoffConfiguration configuration;
    private final List<Range> offRanges;
    private Map<Integer, Period> sequence;
    private boolean disabled;

    public BackoffSimulation(Period delay, Period frequency, BackoffConfiguration configuration) {
        this.delay = delay;
        this.frequency = frequency;
        this.configuration = configuration;
        this.offRanges = new LinkedList<Range>();
        this.sequence = new HashMap<Integer, Period>();
        this.disabled = false;
    }

    public BackoffSimulation disabled() {
        this.disabled = true;
        return this;
    }

    public BackoffSimulation off(int from, int to) {
        this.offRanges.add(new Range(from, to));
        return this;
    }

    public BackoffSimulation off(int from, int to, int statusCode) {
        this.offRanges.add(new Range(from, to, statusCode));
        return this;
    }

    public BackoffSimulation simulate(int lastIteration) {
        LinkedList<Range> offRangesToSimulate = new LinkedList<Range>(this.offRanges);
        Range firstBackingOffRange = this.firstBackingOffRange(offRangesToSimulate);
        boolean backingOn = false;
        int step = 0;
        this.sequence.put(0, this.delay);
        for (int i = 1; i < lastIteration; ++i) {
            if (firstBackingOffRange == null || i < firstBackingOffRange.from()) {
                if ((step = Math.max(Math.min(step - 1, this.configuration.backonSteps()), 0)) == 0) {
                    this.sequence.put(i, this.frequency);
                    backingOn = false;
                    continue;
                }
                this.sequence.put(i, this.backon(step));
                backingOn = true;
                continue;
            }
            if (firstBackingOffRange.contains(i)) {
                step = backingOn ? Math.min(step, this.configuration.backoffSteps()) : Math.min(step + 1, this.configuration.backoffSteps());
                backingOn = false;
                this.sequence.put(i, this.backoff(step));
                continue;
            }
            offRangesToSimulate.remove(0);
            firstBackingOffRange = this.firstBackingOffRange(offRangesToSimulate);
            --i;
        }
        return this;
    }

    public List<Range> failingRanges() {
        return this.offRanges;
    }

    public long delay(int ithIteration) {
        return this.sequence.get(ithIteration).inMillis();
    }

    public int statusCode(int ithIteration, int okStatus) {
        return this.failingRanges().stream().filter(range -> range.contains(ithIteration)).findFirst().orElse(new Range(0, 0, okStatus)).statusCode();
    }

    private Period backoff(int step) {
        return this.disabled ? this.frequency : Period.seconds((int)((Integer)this.configuration.backoff().apply(step)));
    }

    private Period backon(int step) {
        return this.disabled ? this.frequency : Period.seconds((int)((Integer)this.configuration.backon().apply(step)));
    }

    private Range firstBackingOffRange(List<Range> offRangesToSimulate) {
        return offRangesToSimulate.size() > 0 ? offRangesToSimulate.get(0) : null;
    }
}

