/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.test.backoff.engine;

import java.util.function.Supplier;
import junit.framework.TestCase;

public class Range {
    private final int from;
    private final int to;
    private final Supplier<Integer> statusCodeClosure;

    public Range(int from, int to) {
        this(from, to, null);
    }

    public Range(int from, int to, Integer statusCode) {
        this.from = from;
        this.to = to;
        this.statusCodeClosure = statusCode != null ? () -> statusCode : () -> {
            TestCase.fail((String)"Status code was requested but has not been set.");
            return 0;
        };
    }

    public boolean contains(int i) {
        return this.from <= i && i < this.to || this.from == i;
    }

    public int from() {
        return this.from;
    }

    public Integer statusCode() {
        return this.statusCodeClosure.get();
    }

    public String toString() {
        return "Range{from=" + this.from + ", to=" + this.to + '}';
    }
}

