/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.test.backoff;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.BackoffScheduler;
import com.mulesoft.anypoint.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.observer.FastRecoveryObserver;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.anypoint.test.backoff.BackoffTestCase;
import com.mulesoft.anypoint.test.backoff.engine.BackoffSimulation;
import com.mulesoft.anypoint.test.backoff.engine.Range;
import com.mulesoft.anypoint.test.backoff.mocks.FailingRangeMetadataProcessor;
import com.mulesoft.anypoint.tests.scheduler.ObservableScheduledExecutorService;
import com.mulesoft.anypoint.tests.scheduler.observer.NonParallelRunnerObserver;
import com.mulesoft.anypoint.tests.scheduler.observer.ScheduledExecutorObserver;
import com.mulesoft.anypoint.tests.scheduler.observer.ScheduledTask;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class BackoffSchedulerTestCase
extends BackoffTestCase {
    private Period delay;
    private Period frequency;
    private BackoffScheduler scheduler;
    private BackoffConfiguration configuration;
    private int pollingRange;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.delay = Period.millis((long)42L);
        this.frequency = Period.millis((long)31416L);
    }

    @Test
    public void failingFastRecoveryTask() {
        this.checkFastRecovery(5);
    }

    @Test
    public void okWithFastRecoveryTask() {
        this.checkFastRecovery(1);
    }

    @Test
    public void reachBackoffLimitWithFastRecoveryTask() {
        this.checkFastRecovery(14);
    }

    private void checkFastRecovery(int iterationsFailing) {
        BackoffRunnable runnable = this.nonParallelScheduler().tenStepsBackoff().runnableFailing(iterationsFailing);
        this.scheduler.schedule(runnable, SchedulingConfiguration.configuration((Period)this.delay), new FastRecoveryObserver[0]);
        MatcherAssert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)iterationsFailing));
        IntStream.range(0, iterationsFailing).forEach(i -> {
            long expectedDelay = i == 0 ? this.delay.inMillis() : this.backoff(i).inMillis();
            MatcherAssert.assertThat((String)this.iteration(i), (Object)((ScheduledTask)this.executorLogger.scheduledTasks().get(i)), (Matcher)Matchers.is((Object)new ScheduledTask((Runnable)runnable, expectedDelay, 0L, TimeUnit.MILLISECONDS)));
        });
    }

    @Test
    public void okReschedulableTask() {
        this.manualScheduler(100).tenStepsBackoff();
        BackoffSimulation simulation = new BackoffSimulation(this.delay, this.frequency, this.configuration).simulate(this.pollingRange);
        this.checkSchedulerMatches(simulation);
    }

    @Test
    public void failingReschedulableTask() {
        this.manualScheduler(100).tenStepsBackoff();
        BackoffSimulation simulation = new BackoffSimulation(this.delay, this.frequency, this.configuration).off(1, 1000).simulate(this.pollingRange);
        this.checkSchedulerMatches(simulation);
    }

    @Test
    public void backoffAndOnCycleReschedulableTask() {
        this.manualScheduler(150).tenStepsBackoffNineBackon();
        BackoffSimulation simulation = new BackoffSimulation(this.delay, this.frequency, this.configuration).off(1, 13).simulate(this.pollingRange);
        this.checkSchedulerMatches(simulation);
    }

    @Test
    public void intermittentStableConnection() {
        this.manualScheduler(200).tenStepsBackoffNineBackon();
        BackoffSimulation simulation = new BackoffSimulation(this.delay, this.frequency, this.configuration).off(5, 8).off(10, 10).off(122, 175).off(179, 183).simulate(this.pollingRange);
        this.checkSchedulerMatches(simulation);
    }

    private void checkSchedulerMatches(BackoffSimulation simulation) {
        BackoffRunnable runnable = this.runnableFailing(simulation.failingRanges());
        this.scheduler.scheduleWithFixedDelay(runnable, SchedulingConfiguration.configuration((Period)this.delay, (Period)this.frequency));
        IntStream.range(0, this.pollingRange).forEach(i -> {
            this.scheduledRunnable(i).run();
            MatcherAssert.assertThat((String)this.iteration(i), (Object)((ScheduledTask)this.executorLogger.scheduledTasks().get(i)), (Matcher)Matchers.is((Object)new ScheduledTask((Runnable)runnable, simulation.delay(i), 0L, TimeUnit.MILLISECONDS)));
        });
        MatcherAssert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)(this.pollingRange + 1)));
    }

    @Test
    public void schedulingShutdown() {
        this.manualScheduler(100).tenStepsBackoff();
        BackoffSimulation simulation = new BackoffSimulation(this.delay, this.frequency, this.configuration).simulate(this.pollingRange);
        BackoffRunnable runnable = this.runnableFailing(simulation.failingRanges());
        boolean beforeExecution = this.executorLogger.isShutdown();
        this.scheduler.scheduleWithFixedDelay(runnable, SchedulingConfiguration.configuration((Period)this.delay, (Period)this.frequency));
        this.scheduledRunnable(0).run();
        this.scheduledRunnable(1).run();
        boolean beforeDispose = this.executorLogger.isShutdown();
        this.scheduler.dispose();
        boolean afterDispose = this.executorLogger.isShutdown();
        MatcherAssert.assertThat((String)"Before execution", (Object)beforeExecution, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Before dispose", (Object)beforeDispose, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"After dispose", (Object)afterDispose, (Matcher)Matchers.is((Object)true));
    }

    private Range from(int from, int to) {
        return new Range(from, to);
    }

    private BackoffRunnable runnableFailing(List<Range> failingRanges) {
        return this.backoffRunnable(failingRanges);
    }

    private BackoffRunnable runnableFailing(int iterationsFailing) {
        return this.backoffRunnable(Arrays.asList(this.from(0, iterationsFailing)));
    }

    private BackoffRunnable backoffRunnable(List<Range> failingRanges) {
        return new BackoffRunnable(this.configuration, new FailingRangeMetadataProcessor(failingRanges)){

            protected SessionMetadata execute() {
                return new SessionMetadata(){

                    public int requests() {
                        return 0;
                    }

                    public List<Integer> statusCodes() {
                        return null;
                    }

                    public int getCount(int statusCode) {
                        return 0;
                    }
                };
            }
        };
    }

    private BackoffSchedulerTestCase tenStepsBackoffNineBackon() {
        this.configuration = new BackoffConfiguration.Builder(true).backoff(2.0, 1.0, 10, Function.identity()).backon(2.0, 1.0, 9, Function.identity()).build();
        return this;
    }

    private BackoffSchedulerTestCase tenStepsBackoff() {
        this.configuration = new BackoffConfiguration.Builder(true).backoff(2.0, 1.0, 10, Function.identity()).fastRecovery().build();
        return this;
    }

    private BackoffSchedulerTestCase nonParallelScheduler() {
        this.scheduler = new BackoffScheduler((ScheduledExecutorService)new ObservableScheduledExecutorService(new ScheduledExecutorObserver[]{this.executorLogger, new NonParallelRunnerObserver()}));
        return this;
    }

    private BackoffSchedulerTestCase manualScheduler(int pollingRange) {
        this.scheduler = new BackoffScheduler((ScheduledExecutorService)new ObservableScheduledExecutorService(new ScheduledExecutorObserver[]{this.executorLogger}));
        this.pollingRange = pollingRange;
        return this;
    }

    private Period backoff(int step) {
        return Period.seconds((int)((Integer)this.configuration.backoff().apply(step)));
    }

    private Period backon(int step) {
        return Period.seconds((int)((Integer)this.configuration.backon().apply(step)));
    }
}

