/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.test.backoff;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.function.dispersion.RangeDispersant;
import com.mulesoft.anypoint.tests.printer.ListPrinter;
import com.mulesoft.anypoint.tests.scheduler.observer.RunnableLoggerObserver;
import com.mulesoft.anypoint.tests.scheduler.observer.ScheduledTask;
import com.mulesoft.mule.runtime.gw.reflection.Inspector;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.util.List;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public abstract class BackoffTestCase {
    protected RunnableLoggerObserver executorLogger;

    public void setUp() {
        this.executorLogger = new RunnableLoggerObserver();
    }

    protected Runnable scheduledRunnable(int ithRunnable) {
        return ((ScheduledTask)this.executorLogger.scheduledTasks().get(ithRunnable)).runnable();
    }

    protected String iteration(int ithIteration) {
        return "Simulation failed on iteration " + ithIteration + "\nScheduled tasks:" + ListPrinter.printer((List)this.executorLogger.scheduledTasks()).print();
    }

    protected BackoffConfiguration withNoDispersion(BackoffConfiguration configuration) {
        MatcherAssert.assertThat((String)"Backoff dispersion function ill configured", (Object)((RangeDispersant)this.read(configuration, "backoffFunction.function.dispersant")), (Matcher)Matchers.is((Object)this.expectedBackoffDispersion()));
        MatcherAssert.assertThat((String)"Backon dispersion function ill configured", (Object)((RangeDispersant)this.read(configuration, "backonFunction.function.dispersant")), (Matcher)Matchers.is((Object)this.expectedBackonDispersion()));
        VariableOverride.overrideVariable((String)"backoffFunction.function.dispersant").in((Object)configuration).with(Function.identity());
        VariableOverride.overrideVariable((String)"backonFunction.function.dispersant").in((Object)configuration).with(Function.identity());
        return configuration;
    }

    protected RangeDispersant expectedBackonDispersion() {
        return new RangeDispersant(0.3, 1.0);
    }

    protected RangeDispersant expectedBackoffDispersion() {
        return new RangeDispersant(0.6, 1.0);
    }

    protected <Input, Output> Output read(Input backoffConfiguration, String variableName) {
        return (Output)new Inspector(backoffConfiguration).read(variableName);
    }
}

