/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.test.retry;

import com.github.valfirst.slf4jtest.LoggingEvent;
import com.github.valfirst.slf4jtest.TestLogger;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.anypoint.backoff.scheduler.BackoffScheduler;
import com.mulesoft.anypoint.backoff.scheduler.configuration.FastRecoveryConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.anypoint.backoff.scheduler.factory.VariableExecutorBackoffSchedulerFactory;
import com.mulesoft.anypoint.retry.BackoffRunnableRetrier;
import com.mulesoft.anypoint.retry.RunnableRetrier;
import com.mulesoft.anypoint.retry.exception.RunnableRetrierException;
import com.mulesoft.anypoint.retry.runnable.RetrierRunnable;
import com.mulesoft.anypoint.test.backoff.scheduler.factory.FixedExecutorBackoffSchedulerFactory;
import com.mulesoft.anypoint.test.retry.FaultyBackoffConfigurationSupplier;
import com.mulesoft.anypoint.tests.logger.LogMatcher;
import com.mulesoft.anypoint.tests.logger.MockLogger;
import com.mulesoft.anypoint.tests.scheduler.ObservableScheduledExecutorService;
import com.mulesoft.anypoint.tests.scheduler.observer.RunnableLoggerObserver;
import com.mulesoft.anypoint.tests.scheduler.observer.ScheduledExecutorObserver;
import com.mulesoft.anypoint.tests.scheduler.observer.ScheduledTask;
import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import com.mulesoft.mule.runtime.gw.reflection.Inspector;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.LogCleanup;
import org.mule.tck.junit4.rule.SystemProperty;
import uk.org.lidalia.slf4jext.Level;

public class BackoffRunnableRetrierTestCase
extends AbstractMuleTestCase {
    public static final String KEY = "key";
    public static final String ANOTHER_KEY = "another-key";
    private static final String THREAD_NAME = "super-thread-name";
    @ClassRule
    public static SystemProperty frequency = new SystemProperty("anypoint.platform.initialization_retry_freq", "1");
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestRule chain = RuleChain.outerRule((TestRule)new LogCleanup());
    private RunnableRetrier<String> runnableRetrier;
    private RunnableLoggerObserver executorLogger;
    private Runnable stableRunnable;
    private Runnable failingRunnable;
    private Runnable runnableThatFailsOnce;
    private TestLogger logger;
    private GatewayConfiguration gatewayConfiguration;

    @Before
    public void setUp() {
        this.retrierWithMockScheduler();
        this.overrideLogger();
    }

    private void retrierWithMockScheduler() {
        this.executorLogger = new RunnableLoggerObserver();
        this.stableRunnable = this.stableRunnable();
        this.failingRunnable = this.failingRunnable();
        this.runnableThatFailsOnce = this.runnableThatFailsOnce();
        this.gatewayConfiguration = new GatewayConfiguration();
        this.createBackoffWhileFailsRetrier(BackoffRunnableRetrier.delayInitialScheduling((int)1));
    }

    @Test
    public void schedulersThreadHasNamed() {
        this.runnableRetrier = new BackoffRunnableRetrier.Builder(THREAD_NAME, this.gatewayConfiguration.platformClient().getOutagesStatusCodes(), this.gatewayConfiguration.platformClient().backoffEnabled().booleanValue()).scheduler((BackoffSchedulerFactory)this.regularScheduler(), BackoffRunnableRetrier.delayInitialScheduling((int)1)).build();
        this.runnableRetrier.scheduleRetry((Object)"someKey", () -> {});
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)new LoggingEvent(Level.TRACE, "BackoffScheduler {} created using factory {}. Thread pool will be {}.", new Object[]{MockLogger.aNumber(), VariableExecutorBackoffSchedulerFactory.class.getSimpleName(), THREAD_NAME})));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.runnableScheduledLog()));
    }

    @Test
    public void retrierWorksWithFastRecoveryConfiguration() {
        this.thrown.expect(RunnableRetrierException.class);
        this.thrown.expectMessage("Backoff configuration should be one of fast recovery.");
        this.runnableRetrier = new BackoffRunnableRetrier.Builder(THREAD_NAME, this.gatewayConfiguration.platformClient().getOutagesStatusCodes(), this.gatewayConfiguration.platformClient().backoffEnabled().booleanValue()).configurationSupplier((BackoffConfigurationSupplier)new FaultyBackoffConfigurationSupplier()).scheduler((BackoffSchedulerFactory)this.regularScheduler(), BackoffRunnableRetrier.delayInitialScheduling((int)1)).build();
    }

    @Test
    public void retrierDisposedAfterSuccessfulRetry() {
        this.runnableRetrier.scheduleRetry((Object)KEY, this.stableRunnable);
        this.retryTask(0).run();
        ((Runnable)Mockito.verify((Object)this.stableRunnable)).run();
        Assert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)1));
        this.assertRetrierDisposed(KEY);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)4));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.schedulerCreatedLog()));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.runnableScheduledLog()));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(2)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.stableRunnableLog()));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(3)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.schedulerDisposeLog()));
    }

    @Test
    public void retrierNotDisposedAfterFailedRetry() {
        Runnable runnable = this.failingRunnable();
        this.runnableRetrier.scheduleRetry((Object)KEY, runnable);
        this.executeRetryRange(0, 10);
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.times((int)10))).run();
        Assert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)11));
        this.assertRetrierAlive(1, KEY);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)12));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.schedulerCreatedLog()));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.runnableScheduledLog()));
        IntStream.range(2, 12).forEach(i -> Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(i)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.unstableRunnableLog())));
    }

    @Test
    public void retrierDisposedAfterRetryWithError() {
        Runnable runnable = this.errorRunnable();
        this.runnableRetrier.scheduleRetry((Object)KEY, runnable);
        Assert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)1));
        this.retryTask(0).run();
        ((Runnable)Mockito.verify((Object)runnable)).run();
        Assert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)1));
        this.assertRetrierDisposed(KEY);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)4));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.schedulerCreatedLog()));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.runnableScheduledLog()));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(2)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.abortedRunnableLog()));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(3)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.schedulerDisposeLog()));
    }

    @Test
    public void retrierDisposedMultipleRunnables() {
        Runnable anotherStableRunnable = this.stableRunnable();
        this.runnableRetrier.scheduleRetry((Object)KEY, this.stableRunnable);
        this.runnableRetrier.scheduleRetry((Object)KEY, anotherStableRunnable);
        this.retryTask(0).run();
        this.retryTask(1).run();
        ((Runnable)Mockito.verify((Object)this.stableRunnable)).run();
        ((Runnable)Mockito.verify((Object)anotherStableRunnable)).run();
        this.assertRetrierDisposed(KEY);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)7));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.schedulerCreatedLog()));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.runnableScheduledLog()));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(2)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.runnableQueuedLog(KEY)));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(3)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.stableRunnableLog()));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(4)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.runnableScheduledLog()));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(5)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.stableRunnableLog()));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(6)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.schedulerDisposeLog()));
    }

    @Test
    public void retrierNotDisposedWhenOneOfMultipleRunnablesFail() {
        Runnable runnable = this.stableRunnable();
        Runnable runnable2 = this.failingRunnable();
        this.runnableRetrier.scheduleRetry((Object)KEY, runnable);
        this.runnableRetrier.scheduleRetry((Object)KEY, runnable2);
        this.retryTask(0).run();
        this.retryTask(1).run();
        ((Runnable)Mockito.verify((Object)runnable)).run();
        ((Runnable)Mockito.verify((Object)runnable2)).run();
        Assert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)3));
        this.assertRetrierAlive(1, KEY);
    }

    @Test
    public void forceExternalDispose() {
        this.runnableRetrier.scheduleRetry((Object)KEY, this.failingRunnable);
        this.executeRetryRange(0, 10);
        this.runnableRetrier.dispose();
        this.assertRetrierDisposed(KEY);
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)13));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.schedulerCreatedLog()));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.runnableScheduledLog()));
        IntStream.range(2, 12).forEach(i -> Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(i)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.unstableRunnableLog())));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(12)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.schedulerDisposeLog()));
    }

    @Test
    public void onlyOneTaskScheduledAtATime() {
        this.runnableRetrier.scheduleRetry((Object)KEY, this.failingRunnable);
        this.runnableRetrier.scheduleRetry((Object)KEY, this.stableRunnable);
        Assert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void whileTaskFailsSecondWontBeScheduled() {
        this.runnableRetrier.scheduleRetry((Object)KEY, this.failingRunnable);
        this.runnableRetrier.scheduleRetry((Object)KEY, this.stableRunnable);
        this.executeRetryRange(0, 10);
        ((Runnable)Mockito.verify((Object)this.failingRunnable, (VerificationMode)Mockito.times((int)10))).run();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.stableRunnable});
    }

    @Test
    public void secondTaskGetsScheduledAfterFirstSucceeds() {
        this.runnableRetrier.scheduleRetry((Object)KEY, this.runnableThatFailsOnce);
        this.runnableRetrier.scheduleRetry((Object)KEY, this.stableRunnable);
        this.retryTask(0).run();
        this.retryTask(1).run();
        this.retryTask(2).run();
        Assert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)3));
        ((Runnable)Mockito.verify((Object)this.runnableThatFailsOnce, (VerificationMode)Mockito.times((int)2))).run();
        ((Runnable)Mockito.verify((Object)this.stableRunnable)).run();
    }

    @Test
    public void secondTaskGetsScheduledAfterFirstCrashes() {
        Runnable errorRunnable = this.errorRunnable();
        this.runnableRetrier.scheduleRetry((Object)KEY, errorRunnable);
        this.runnableRetrier.scheduleRetry((Object)KEY, this.stableRunnable);
        this.retryTask(0).run();
        this.retryTask(1).run();
        Assert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)2));
        ((Runnable)Mockito.verify((Object)errorRunnable)).run();
        ((Runnable)Mockito.verify((Object)this.stableRunnable)).run();
    }

    @Test
    public void tasksAreScheduledAfterTaskCrashes() {
        Runnable errorRunnable = this.errorRunnable();
        this.runnableRetrier.scheduleRetry((Object)KEY, errorRunnable);
        this.retryTask(0).run();
        Assert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)1));
        ((Runnable)Mockito.verify((Object)errorRunnable)).run();
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)4));
        this.logger.clearAll();
        this.runnableRetrier.scheduleRetry((Object)KEY, this.stableRunnable);
        this.retryTask(1).run();
        ((Runnable)Mockito.verify((Object)this.stableRunnable)).run();
        Assert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)4));
    }

    @Test
    public void taskCanBeScheduledByKey() {
        this.runnableRetrier.scheduleRetry((Object)ANOTHER_KEY, this.failingRunnable);
        this.runnableRetrier.scheduleRetry((Object)KEY, this.stableRunnable);
        Assert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)2));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.failingRunnable});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.stableRunnable});
        Assert.assertThat((Object)this.logger.getAllLoggingEvents(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(0)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.schedulerCreatedLog()));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(1)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.runnableScheduledLog()));
        Assert.assertThat((Object)((LoggingEvent)this.logger.getAllLoggingEvents().get(2)), (Matcher)LogMatcher.logMatches((LoggingEvent)this.runnableScheduledLog()));
    }

    @Test
    public void tasksWithDifferentKeysAreExecutedIndependently() {
        this.runnableRetrier.scheduleRetry((Object)ANOTHER_KEY, this.failingRunnable);
        this.runnableRetrier.scheduleRetry((Object)KEY, this.stableRunnable);
        this.retryTask(0).run();
        this.retryTask(1).run();
        Assert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)3));
        ((Runnable)Mockito.verify((Object)this.failingRunnable)).run();
        ((Runnable)Mockito.verify((Object)this.stableRunnable)).run();
    }

    @Test
    public void automaticDisposeWhenAllKeysAreSuccessfullyProcessed() {
        this.runnableRetrier.scheduleRetry((Object)ANOTHER_KEY, this.runnableThatFailsOnce);
        this.runnableRetrier.scheduleRetry((Object)KEY, this.stableRunnable);
        this.executeRetryRange(0, 3);
        Assert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)3));
        ((Runnable)Mockito.verify((Object)this.runnableThatFailsOnce, (VerificationMode)Mockito.times((int)2))).run();
        ((Runnable)Mockito.verify((Object)this.stableRunnable)).run();
        this.assertRetrierDisposed(KEY, ANOTHER_KEY);
    }

    @Test
    public void disposeWithoutAddingTaskDoesNotRaiseException() {
        this.runnableRetrier.dispose();
        Assert.assertThat((String)"Retrier scheduler is not null", (Object)this.retrierScheduler(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void addStableRunnablesWhileRunning() {
        Runnable anotherRunnable = this.stableRunnable();
        Runnable aThirdRunnable = this.stableRunnable();
        Runnable aFourthRunnable = this.stableRunnable();
        this.runnableRetrier.scheduleRetry((Object)KEY, this.stableRunnable);
        this.retryTask(0).run();
        ((Runnable)Mockito.verify((Object)this.stableRunnable)).run();
        Mockito.verifyNoInteractions((Object[])new Object[]{anotherRunnable, aThirdRunnable, aFourthRunnable});
        this.runnableRetrier.scheduleRetry((Object)KEY, anotherRunnable).scheduleRetry((Object)KEY, aThirdRunnable);
        this.retryTask(1).run();
        this.retryTask(2).run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stableRunnable});
        ((Runnable)Mockito.verify((Object)anotherRunnable)).run();
        ((Runnable)Mockito.verify((Object)aThirdRunnable)).run();
        Mockito.verifyNoInteractions((Object[])new Object[]{aFourthRunnable});
        this.runnableRetrier.scheduleRetry((Object)KEY, aFourthRunnable);
        this.retryTask(3).run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stableRunnable, anotherRunnable, aThirdRunnable});
        ((Runnable)Mockito.verify((Object)aFourthRunnable)).run();
        this.assertRetrierDisposed(KEY);
    }

    @Test
    public void multipleFailingRunnablesOverDifferentKeys() {
        Runnable stableRunnableKey0 = this.stableRunnable();
        Runnable failingRunnableKey0 = this.failingRunnable();
        Runnable runnableThatRecoversKey1 = this.runnableThatFailsOnce();
        Runnable failingRunnableKey1 = this.failingRunnable();
        Runnable failingRunnableKey2 = this.failingRunnable();
        Runnable stableRunnableKey3 = this.stableRunnable();
        this.runnableRetrier.scheduleRetry((Object)"0", stableRunnableKey0).scheduleRetry((Object)"0", failingRunnableKey0).scheduleRetry((Object)"1", runnableThatRecoversKey1).scheduleRetry((Object)"1", failingRunnableKey1).scheduleRetry((Object)"2", failingRunnableKey2).scheduleRetry((Object)"3", stableRunnableKey3);
        this.executeRetryRange(0, 6);
        ((Runnable)Mockito.verify((Object)stableRunnableKey0)).run();
        ((Runnable)Mockito.verify((Object)stableRunnableKey3)).run();
        this.executeRetryRange(6, 10);
        ((Runnable)Mockito.verify((Object)runnableThatRecoversKey1, (VerificationMode)Mockito.times((int)2))).run();
        this.executeRetryRange(10, 40);
        ((Runnable)Mockito.verify((Object)failingRunnableKey0, (VerificationMode)Mockito.times((int)12))).run();
        ((Runnable)Mockito.verify((Object)failingRunnableKey1, (VerificationMode)Mockito.times((int)11))).run();
        ((Runnable)Mockito.verify((Object)failingRunnableKey2, (VerificationMode)Mockito.times((int)13))).run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{stableRunnableKey0, failingRunnableKey0, runnableThatRecoversKey1, failingRunnableKey1, failingRunnableKey2, stableRunnableKey3});
    }

    @Test
    public void retrierCanBeConfiguredToDiscardWhenNewRunnableArrives() {
        this.runnableRetrier = new BackoffRunnableRetrier.Builder(THREAD_NAME, this.gatewayConfiguration.platformClient().getOutagesStatusCodes(), this.gatewayConfiguration.platformClient().backoffEnabled().booleanValue()).retryUntilNewSchedule().scheduler((BackoffSchedulerFactory)this.observableScheduler(), BackoffRunnableRetrier.delayInitialScheduling((int)1)).build();
        this.runnableRetrier.scheduleRetry((Object)KEY, this.failingRunnable);
        this.retryTask(0).run();
        this.runnableRetrier.scheduleRetry((Object)KEY, this.stableRunnable);
        this.retryTask(1).run();
        this.retryTask(2).run();
        Assert.assertThat((Object)this.executorLogger.scheduledTasks(), (Matcher)Matchers.hasSize((int)3));
        this.assertRetrierDisposed(KEY);
    }

    @Test
    public void initialDelayIsConfigurable() {
        this.createBackoffWhileFailsRetrier(BackoffRunnableRetrier.zeroDelayOnScheduling());
        this.runnableRetrier.scheduleRetry((Object)KEY, this.stableRunnable());
        Assert.assertThat((Object)((ScheduledTask)this.executorLogger.scheduledTasks().get(0)).delay(), (Matcher)Is.is((Object)0L));
    }

    private void createBackoffWhileFailsRetrier(SchedulingConfiguration schedulingConfiguration) {
        this.runnableRetrier = new BackoffRunnableRetrier.Builder(THREAD_NAME, this.gatewayConfiguration.platformClient().getOutagesStatusCodes(), this.gatewayConfiguration.platformClient().backoffEnabled().booleanValue()).scheduler((BackoffSchedulerFactory)this.observableScheduler(), schedulingConfiguration).build();
    }

    private FixedExecutorBackoffSchedulerFactory observableScheduler() {
        return this.observableScheduler((ScheduledExecutorService)new ObservableScheduledExecutorService(new ScheduledExecutorObserver[]{this.executorLogger}));
    }

    private FixedExecutorBackoffSchedulerFactory observableScheduler(ScheduledExecutorService executorService) {
        return new FixedExecutorBackoffSchedulerFactory(executorService);
    }

    private VariableExecutorBackoffSchedulerFactory regularScheduler() {
        return new VariableExecutorBackoffSchedulerFactory();
    }

    private void executeRetryRange(int startInclusive, int endExclusive) {
        IntStream.range(startInclusive, endExclusive).forEach(i -> this.retryTask(i).run());
    }

    private Runnable retryTask(int i) {
        return ((ScheduledTask)this.executorLogger.scheduledTasks().get(i)).runnable();
    }

    private Runnable stableRunnable() {
        return (Runnable)Mockito.mock(Runnable.class);
    }

    private Runnable failingRunnable() {
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        ((Runnable)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)runnable)).run();
        return runnable;
    }

    private Runnable errorRunnable() {
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        ((Runnable)Mockito.doThrow((Throwable[])new Throwable[]{new InternalError()}).when((Object)runnable)).run();
        return runnable;
    }

    private Runnable runnableThatFailsOnce() {
        Runnable mock = (Runnable)Mockito.mock(Runnable.class);
        ((Runnable)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).doNothing().when((Object)mock)).run();
        return mock;
    }

    private void assertRetrierAlive(int amountOfScheduledTasks, String key) {
        Assert.assertThat((String)"Retrier scheduler is null", (Object)this.retrierScheduler(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Scheduled tasks error", this.scheduledRunnables(key), (Matcher)Matchers.hasSize((int)amountOfScheduledTasks));
    }

    private void assertRetrierDisposed(String ... keys) {
        Assert.assertThat((String)"Scheduler has not been shutdown", (Object)this.executorLogger.isShutdown(), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)"Retrier scheduler is not null", (Object)this.retrierScheduler(), (Matcher)Matchers.nullValue());
        Arrays.asList(keys).forEach(key -> Assert.assertThat((String)"There are still scheduled runnables", this.scheduledRunnables((String)key), (Matcher)Matchers.nullValue()));
    }

    private BackoffScheduler retrierScheduler() {
        return (BackoffScheduler)new Inspector(this.runnableRetrier).read("scheduler");
    }

    private List<Runnable> scheduledRunnables(String key) {
        Map runnables = (Map)new Inspector(this.runnableRetrier).read("runnables");
        return (List)runnables.get(key);
    }

    private void overrideLogger() {
        this.logger = TestLoggerFactory.getTestLogger(this.runnableRetrier.getClass());
    }

    private LoggingEvent schedulerDisposeLog() {
        return new LoggingEvent(Level.TRACE, "Disposing BackoffScheduler {}", new Object[]{MockLogger.aNumber()});
    }

    private LoggingEvent stableRunnableLog() {
        return new LoggingEvent(Level.TRACE, "BackoffRunnable {} is now stable, it will be removed. Inner runnable {} has been dropped.", new Object[]{MockLogger.instanceOf(RetrierRunnable.class), MockLogger.aNumber()});
    }

    private LoggingEvent abortedRunnableLog() {
        return new LoggingEvent(Level.TRACE, "BackoffRunnable {} finished with error, it will be dropped and removed from the queue.", new Object[]{MockLogger.instanceOf(RetrierRunnable.class)});
    }

    private LoggingEvent runnableScheduledLog() {
        return new LoggingEvent(Level.TRACE, "Scheduling runnable {} in BackoffRunnable {} with configuration {}.", new Object[]{MockLogger.aNumber(), MockLogger.instanceOf(RetrierRunnable.class), SchedulingConfiguration.configuration((Period)Period.millis((long)1000L), (Period)Period.millis((long)0L))});
    }

    private LoggingEvent schedulerCreatedLog() {
        return new LoggingEvent(Level.TRACE, "BackoffScheduler {} created using factory {}. Thread pool will be {}.", new Object[]{MockLogger.aNumber(), FixedExecutorBackoffSchedulerFactory.class.getSimpleName(), THREAD_NAME});
    }

    private LoggingEvent unstableRunnableLog() {
        return new LoggingEvent(Level.TRACE, "BackoffRunnable {} remains unstable, it will be retried with configuration {}.", new Object[]{MockLogger.instanceOf(RetrierRunnable.class), MockLogger.instanceOf(FastRecoveryConfiguration.class)});
    }

    private LoggingEvent runnableQueuedLog(String key) {
        return new LoggingEvent(Level.TRACE, "There is a runnable running for key {}. Runnable {} will be queued.", new Object[]{key, MockLogger.aNumber()});
    }
}

