/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.adapter;

import static com.mulesoft.mule.runtime.gw.model.PolicySet.PolicySetOrigin.PLATFORM;
import static java.util.stream.Collectors.toList;

import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.contract.tier.SingleTier;
import com.mulesoft.mule.runtime.gw.api.contract.tier.Tier;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.client.dto.ApiDto;
import com.mulesoft.mule.runtime.gw.client.dto.LimitDto;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.model.ApiTrackingInfo;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.TrackingInfo;

import java.util.List;
import java.util.Objects;

public class ApiResponseBuilder {

  private PolicyDefinitionBuilder policyDefinitionBuilder = new PolicyDefinitionBuilder();

  private ApiDto api;
  private String entityTag;
  private boolean noUpdates;

  public ApiResponseBuilder noUpdates() {
    this.noUpdates = true;
    return this;
  }

  public ApiResponseBuilder withApi(ApiDto api) {
    this.api = api;
    return this;
  }

  public ApiResponseBuilder withEntityTag(String entityTag) {
    this.entityTag = entityTag;
    return this;
  }

  public ApiResponse build() {
    return noUpdates ? new ApiResponse(null, null, null, false) : new ApiResponse(trackingInfo(), policySet(), slas(), true);
  }

  private List<Sla> slas() {
    return api.getTiers().stream()
        .filter(Objects::nonNull)
        .map(tierDto -> new Sla(tierDto.getId(), mapToTiers(tierDto.getLimits())))
        .collect(toList());
  }

  private PolicySet policySet() {
    List<PolicyDefinition> policies = api.getPolicies().stream()
        .map(dto -> policyDefinitionBuilder.from(new ApiKey(api.getId()), dto, api.getEndpointType(),
                                                 api.getIdentityManagement()))
        .collect(toList());

    return new PolicySet(policies, PLATFORM);
  }

  private TrackingInfo trackingInfo() {
    return new ApiTrackingInfo(api.getId(), api.getInstanceName(), api.getGroupId(), api.getAssetId(),
                               api.getVersion(), api.getOrganizationId(), api.getEnvironmentId(), api.getEndpointType(),
                               api.getLegacyApiIdentifier(), entityTag, api.getExchangeAssetName(), api.getProductVersion());
  }

  private List<Tier> mapToTiers(List<LimitDto> limits) {
    return limits.stream()
        .map(limit -> new SingleTier(limit.getMaximumRequests(), limit.getTimePeriodInMilliseconds()))
        .collect(toList());
  }

}
