/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.dto;

import static java.lang.Integer.valueOf;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static org.mule.runtime.core.api.util.StringUtils.isBlank;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;

import java.io.Serializable;
import java.util.Optional;
import java.util.Set;


public class ApiClientDto implements Serializable {

  private static final long serialVersionUID = -7040601262987866805L;
  private String id;
  private String secret;
  private String name;
  private String organizationId;
  private String slaTierId;
  private String apiId;
  private String contractId;
  private Set<String> redirectUris;

  private ContractDto contract;

  @JsonCreator
  public ApiClientDto(@JsonProperty("clientId") String id, @JsonProperty("clientSecret") String secret,
                      @JsonProperty("clientName") String name, @JsonProperty("organizationId") String organizationId,
                      @JsonProperty("slaTierId") String slaTierId, @JsonProperty("apiId") String apiId,
                      @JsonProperty("contractId") String contractId, @JsonProperty("redirectUris") Set<String> redirectUris) {
    this.id = id;
    this.secret = secret;
    this.name = name;
    this.organizationId = organizationId;
    this.slaTierId = slaTierId;
    this.apiId = apiId;
    this.contractId = contractId;
    this.redirectUris = redirectUris;
  }

  public String getId() {
    return id;
  }

  public String getSecret() {
    return secret;
  }

  public String getName() {
    return name;
  }

  public String getOrganizationId() {
    return organizationId;
  }

  public Optional<Integer> getSlaTierId() {
    return !isBlank(slaTierId) ? of(valueOf(slaTierId)) : empty();
  }

  public String getApiId() {
    return apiId;
  }

  public String getContractId() {
    return contractId;
  }

  public Set<String> getRedirectUris() {
    return redirectUris;
  }

  public void setContract(ContractDto contract) {
    this.contract = contract;
  }

  @JsonIgnore
  public ContractDto getContract() {
    return contract;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiClientDto that = (ApiClientDto) o;
    return Objects.equal(id, that.id) &&
        Objects.equal(secret, that.secret) &&
        Objects.equal(name, that.name) &&
        Objects.equal(organizationId, that.organizationId) &&
        Objects.equal(slaTierId, that.slaTierId) &&
        Objects.equal(apiId, that.apiId) &&
        Objects.equal(contractId, that.contractId) &&
        Objects.equal(redirectUris, that.redirectUris);
  }

  @Override
  public int hashCode() {
    return Objects.hashCode(id, secret, name, organizationId, slaTierId, apiId, contractId, redirectUris);
  }

  @Override
  public String toString() {
    return "ApiClientDto{" +
        "slaTierId='" + slaTierId + '\'' +
        '}';
  }
}
