/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.dto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Map;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown = true)
public class ConfigurationDto {

  @JsonProperty("itemName")
  private String itemName;

  @JsonProperty("itemData")
  private Map<String, Object> itemData;

  public String getItemName() {
    return itemName;
  }

  public void setItemName(String itemName) {
    this.itemName = itemName;
  }

  public Map<String, Object> getItemData() {
    return itemData;
  }

  public void setItemData(Map<String, Object> itemData) {
    this.itemData = itemData;
  }

  public ConfigurationDto(String name, Map<String, Object> data) {
    itemData = data;
    itemName = name;
  }

  public ConfigurationDto() {}
}
