/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;

import java.io.Serializable;
import java.util.Set;

public class CoreServicesClientDto implements Serializable {

  private static final long serialVersionUID = -7040601262987866805L;
  private String id;
  private String secret;
  private String name;
  private String organizationId;
  private Set<String> redirectUris;

  @JsonCreator
  public CoreServicesClientDto(@JsonProperty("client_id") String id, @JsonProperty("client_secret") String secret,
                               @JsonProperty("name") String name, @JsonProperty("org_id") String organizationId,
                               @JsonProperty("redirect_uris") Set<String> redirectUris) {
    this.id = id;
    this.secret = secret;
    this.name = name;
    this.organizationId = organizationId;
    this.redirectUris = redirectUris;
  }

  public String getId() {
    return id;
  }

  public String getSecret() {
    return secret;
  }

  public String getName() {
    return name;
  }

  public String getOrganizationId() {
    return organizationId;
  }

  public Set<String> getRedirectUris() {
    return redirectUris;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CoreServicesClientDto that = (CoreServicesClientDto) o;
    return Objects.equal(id, that.id) &&
        Objects.equal(secret, that.secret) &&
        Objects.equal(name, that.name) &&
        Objects.equal(organizationId, that.organizationId) &&
        Objects.equal(redirectUris, that.redirectUris);
  }

  @Override
  public int hashCode() {
    return Objects.hashCode(id, secret, name, organizationId, redirectUris);
  }

}
