/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.dto;

import java.util.Optional;

public class PlatformContractAdapter {

  private final ApiClientDto client;

  public PlatformContractAdapter(ApiClientDto client) {
    this.client = client;
  }

  public String clientId() {
    return client.getId();
  }

  public String clientSecret() {
    return client.getSecret();
  }

  public String clientName() {
    return client.getName();
  }

  public Optional<Integer> slaId() {
    return client.getSlaTierId();
  }

  @Override
  public String toString() {
    return "PlatformContractAdapter{ platformContractAdapter= " + client.getSlaTierId().orElse(-1) + '}';
  }

  public boolean equals(Object o) {
    if (this == o) {
      return true;
    } else if (!(o instanceof PlatformContractAdapter)) {
      return false;
    } else {
      PlatformContractAdapter client = (PlatformContractAdapter) o;
      return !this.clientId().equals(client.clientId()) ? false : this.clientSecret().equals(client.clientSecret());
    }
  }

}
