/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.exception;

import org.slf4j.Logger;
import static com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor.errorMessage;

public class RecoverableExceptionMessageLogger implements NormalizedExceptionMessageLogger {

  private static final String ERROR_MESSAGE = "Failed to {}. This request will be retried after some backoff time. {}";
  private static final String ERROR_MESSAGE_WITH_PARAMETER =
      "Failed to {} '{}'. This request will be retried after some backoff time. {}";
  private static final String DEBUG_INFO_MESSAGE = "Logging full throwable.";

  private final Logger logger;

  public RecoverableExceptionMessageLogger(Logger logger) {
    this.logger = logger;
  }

  @Override
  public void warn(String failedActionDescription, Throwable e) {
    logger.warn(ERROR_MESSAGE, failedActionDescription, errorMessage(e));
    debugInfo(e);
  }

  @Override
  public void warn(String failedActionDescription, Object parameter, Throwable e) {
    logger.warn(ERROR_MESSAGE_WITH_PARAMETER, failedActionDescription, parameter, errorMessage(e));
    debugInfo(e);
  }

  @Override
  public void error(String failedActionDescription, Throwable e) {
    logger.error(ERROR_MESSAGE, failedActionDescription, errorMessage(e));
    debugInfo(e);
  }

  @Override
  public void error(String failedActionDescription, Object parameter, Throwable e) {
    logger.error(ERROR_MESSAGE_WITH_PARAMETER, failedActionDescription, parameter, errorMessage(e));
    debugInfo(e);
  }

  private void debugInfo(Throwable e) {
    logger.debug(DEBUG_INFO_MESSAGE, e);
  }

}
