/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient.interceptors;

import com.mulesoft.mule.runtime.gw.client.exception.EntityParsingException;
import com.mulesoft.mule.runtime.gw.client.model.Authentication;

import com.google.common.collect.ImmutableList;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;

import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class Oauth2ClientCredentialsInterceptor extends Oauth2Interceptor {

  private URI tokenUrl;
  private String clientId;
  private String clientSecret;

  public Oauth2ClientCredentialsInterceptor(HttpClient client, URI tokenUrl, URI loginUrl, String clientId, String clientSecret) {
    super(client, loginUrl);
    this.tokenUrl = tokenUrl;
    this.clientId = clientId;
    this.clientSecret = clientSecret;
  }

  @Override
  public String authenticate() {
    try {
      List<NameValuePair> form =
          ImmutableList.of(new BasicNameValuePair("grant_type", "client_credentials"),
                           new BasicNameValuePair("client_id", clientId),
                           new BasicNameValuePair("client_secret", clientSecret));

      UrlEncodedFormEntity entity = new UrlEncodedFormEntity(form, "UTF-8");

      HttpResponse response = executePost(tokenUrl, entity);

      return processResponse(response, Authentication.class).getAccessToken();
    } catch (UnsupportedEncodingException e) {
      throw new EntityParsingException("Error building HTTP Request entity", e);
    }
  }

}
