/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient.interceptors;

import static java.lang.String.format;
import static org.mule.runtime.core.api.config.MuleManifest.getProductVersion;
import static org.mule.runtime.http.api.HttpHeaders.Names.USER_AGENT;

import java.net.InetAddress;
import java.net.UnknownHostException;

import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentEnricherInterceptor implements HttpRequestResponseInterceptor {

  private static final Logger LOGGER = LoggerFactory.getLogger(UserAgentEnricherInterceptor.class);

  private String agent;

  public UserAgentEnricherInterceptor() {
    String gatewayVersion = getProductVersion();
    String javaVersion = System.getProperty("java.version");
    try {
      String hostName = InetAddress.getLocalHost().getHostName();
      agent = format("API Gateway %s (Java/%s) (%s)", gatewayVersion, javaVersion, hostName);
    } catch (UnknownHostException e) {
      LOGGER.warn("Error obtaining hostname. Header User-Agent will be sent without hostname information. {}.", e.getMessage());
      agent = format("API Gateway %s (Java/%s)", gatewayVersion, javaVersion);
    }
  }

  public void process(HttpRequest httpRequest, HttpContext httpContext) {
    httpRequest.setHeader(USER_AGENT, agent);
  }

  public void process(HttpResponse httpResponse, HttpContext httpContext) {}

}
