/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.model;

import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.TrackingInfo;

import java.util.List;

public class ApiResponse {

  private final TrackingInfo trackingInfo;
  private final PolicySet policySet;
  private final List<Sla> slas;
  private final Boolean hasUpdates;

  public ApiResponse(TrackingInfo trackingInfo, PolicySet policySet, List<Sla> slas, boolean hasUpdates) {
    this.trackingInfo = trackingInfo;
    this.policySet = policySet;
    this.slas = slas;
    this.hasUpdates = hasUpdates;
  }

  public Boolean hasUpdates() {
    return hasUpdates;
  }

  public int countPolicies() {
    return policySet.getPolicyDefinitions().size();
  }

  public TrackingInfo getTrackingInfo() {
    return trackingInfo;
  }

  public List<Sla> getSlas() {
    return slas;
  }

  public PolicySet getPolicySet() {
    return policySet;
  }
}
