/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.session;

import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.client.dto.ApiClientDto;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.model.Api;

import java.util.List;

//TODO AGW-1561: Make Platform Session return Gateway's model objects
/**
 * Creates a session to query ApiPlatform and abstracts the way data is retrieved from it.
 */
public interface ApiPlatformSession {

  /**
   * @return current's session metadata.
   */
  SessionMetadata metadata();

  /**
   * Activates an endpoint in ApiPlatform.
   *
   * @param organizationId {@link String}
   * @param environmentId {@link String}
   * @param apiId {@link Integer}
   * @return this
   */
  ApiPlatformSession activateEndpoint(String organizationId, String environmentId, Long apiId);

  /**
   * Retrieves {@link Client} for an specific {@link Api}
   *
   * @param organizationId {@link String}
   * @param environmentId {@link String}
   * @param apiId {@link Integer}
   * @return a list of {@link ApiClientDto}s
   */
  List<ApiClientDto> getApiClients(String organizationId, String environmentId, Long apiId);

  /**
   * Retrieves an {@link Api} using the local data.
   * 
   * @param api {@link Api}
   * @return an {@link ApiResponse}.
   */
  ApiResponse getApi(Api api);

  /**
   * Retrieves an {@link Api} using the local data.
   * 
   * @param apiKey {@link ApiKey}
   * @return an {@link ApiResponse}.
   */
  ApiResponse getApi(ApiKey apiKey);

  /**
   * Retrieves an {@link Api} using the local data.
   * 
   * @param apiKey {@link ApiKey}
   * @param entityTag {@link String}
   * @return an {@link ApiResponse}.
   */
  ApiResponse getApi(ApiKey apiKey, String entityTag);
}
