/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.session.metadata;

import com.mulesoft.mule.runtime.gw.backoff.session.SessionMetadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

//TODO AGW-1570: Backoff - Refactor session metadata
public class ApiPlatformSessionMetadata implements SessionMetadata {

  private final Map<Integer, Integer> responses;

  public ApiPlatformSessionMetadata(Map<Integer, Integer> responses) {
    this.responses = responses;
  }

  public ApiPlatformSessionMetadata(int statusCode) {
    responses = new HashMap<>();
    responses.put(statusCode, 1);
  }

  @Override
  public int requests() {
    return responses.values().stream().mapToInt(Integer::intValue).sum();
  }

  @Override
  public List<Integer> statusCodes() {
    return new ArrayList<>(responses.keySet());
  }

  @Override
  public int getCount(int statusCode) {
    return responses.getOrDefault(statusCode, 0);
  }
}
