/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.session.metadata;

import com.mulesoft.mule.runtime.gw.api.construction.Builder;
import com.mulesoft.mule.runtime.gw.backoff.session.SessionMetadata;

import java.util.HashMap;
import java.util.Map;

//TODO AGW-1570: Backoff - Refactor session metadata
public class ApiPlatformSessionMetadataBuilder implements Builder<SessionMetadata> {

  private Map<Integer, Integer> responses = new HashMap<>();

  /**
   * Notifies of a new response and the status code
   *
   * @param statusCode the response status code
   */
  public ApiPlatformSessionMetadataBuilder response(int statusCode) {
    if (!responses.containsKey(statusCode)) {
      responses.put(statusCode, 1);
    } else {
      responses.put(statusCode, responses.get(statusCode) + 1);
    }
    return this;
  }


  @Override
  public SessionMetadata build() {
    return new ApiPlatformSessionMetadata(responses);
  }
}
