/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.uri;

import java.net.URI;

/**
 * UriBuilder interface designed to have our own custom set of java.net.URI builders.
 */
public interface UriBuilder {

  /**
   * Sets the base uri that the builder will use to start constructing the uri from.
   *
   * @param path specifies the base uri
   * @return the same instance of the builder.
   */
  UriBuilder fromUri(String path);

  /**
   * Append to the path of the URI. This can have named placeholders of the form {param}, that will be filled out at the moment of
   * the building of the URI (@see "build"). Take into account that this will *not* remove double slashes on the resulting path.
   *
   * Example of path: "/service/{applicationName}/get"
   *
   * @param path specifies the path to be appended to the URI.
   * @return the same instance of the builder.
   */
  UriBuilder appendPath(String path);

  /**
   * Add a query string parameter to the URI.
   *
   * @param name specifies the name of the query string param.
   * @param value specifies the value of the query string param.
   * @return the same instance of the builder.
   */
  UriBuilder queryParam(String name, String value);

  /**
   * Builds the URI based on the URI members previously load. You can also specify values for each of the placeholders you
   * specified in the path.
   *
   * @param params specifies a list of objects representing the values of the placeholders within the path.
   * @return the fully constructed java.net.URI based on the URI members previously loaded.
   */
  URI build(Object... params);

}
