/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.mocks;

import java.io.ByteArrayInputStream;
import java.io.IOException;

public class CloseVerifiedInputStream extends ByteArrayInputStream {

  private boolean closed;

  public CloseVerifiedInputStream(byte[] input) {
    super(input);
    closed = false;
  }

  @Override
  public void close() throws IOException {
    super.close();
    closed = true;
  }

  public boolean wasClosed() {
    return closed;
  }
}
