/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.exception;

import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.client.exception.NormalizedExceptionMessageLogger;
import org.slf4j.Logger;

public class RecoverableExceptionMessageLogger
implements NormalizedExceptionMessageLogger {
    private static final String ERROR_MESSAGE = "Failed to {}. This request will be retried after some backoff time. {}";
    private static final String ERROR_MESSAGE_WITH_PARAMETER = "Failed to {} '{}'. This request will be retried after some backoff time. {}";
    private static final String DEBUG_INFO_MESSAGE = "Logging full throwable.";
    private final Logger logger;

    public RecoverableExceptionMessageLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void warn(String failedActionDescription, Throwable e) {
        this.logger.warn(ERROR_MESSAGE, (Object)failedActionDescription, (Object)ExceptionDescriptor.errorMessage((Throwable)e));
        this.debugInfo(e);
    }

    @Override
    public void warn(String failedActionDescription, Object parameter, Throwable e) {
        this.logger.warn(ERROR_MESSAGE_WITH_PARAMETER, new Object[]{failedActionDescription, parameter, ExceptionDescriptor.errorMessage((Throwable)e)});
        this.debugInfo(e);
    }

    @Override
    public void error(String failedActionDescription, Throwable e) {
        this.logger.error(ERROR_MESSAGE, (Object)failedActionDescription, (Object)ExceptionDescriptor.errorMessage((Throwable)e));
        this.debugInfo(e);
    }

    @Override
    public void error(String failedActionDescription, Object parameter, Throwable e) {
        this.logger.error(ERROR_MESSAGE_WITH_PARAMETER, new Object[]{failedActionDescription, parameter, ExceptionDescriptor.errorMessage((Throwable)e)});
        this.debugInfo(e);
    }

    private void debugInfo(Throwable e) {
        this.logger.debug(DEBUG_INFO_MESSAGE, e);
    }
}

