/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient.interceptors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.client.exception.EntityParsingException;
import com.mulesoft.mule.runtime.gw.client.exception.EntityUnparsingException;
import com.mulesoft.mule.runtime.gw.client.exception.HttpConnectionException;
import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.exception.UnauthorizedException;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.AccessTokenManager;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.AccessTokens;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.GatewayAuthScheme;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.HttpRequestResponseInterceptor;
import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.ResettableInterceptor;
import com.mulesoft.mule.runtime.gw.client.model.PortalAuthentication;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;

public abstract class Oauth2Interceptor
implements HttpRequestResponseInterceptor,
ResettableInterceptor {
    private static final String ACCESS_TOKEN_KEY = "com.mulesoft.module.client.httpclient.interceptors.accessToken";
    private final URI loginUrl;
    private final ObjectMapper objectMapper;
    private final HttpClient client;
    private final AccessTokenManager tokenManager;

    protected Oauth2Interceptor(HttpClient client, URI loginUrl) {
        this.client = client;
        this.loginUrl = loginUrl;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.tokenManager = new AccessTokenManager();
    }

    public void process(HttpRequest request, HttpContext context) {
        String authorizationHeaderToken;
        AccessTokens tokens = this.tokenManager.getUpdatedTokens(this::authenticate, this::exchangeToken);
        if (request.containsHeader("Authorization")) {
            request.removeHeaders("Authorization");
        }
        HttpClientContext clientContext = (HttpClientContext)context;
        String string = authorizationHeaderToken = request.getRequestLine().getUri().contains("/apigateway/apimanager/v1") || request.getRequestLine().getUri().contains("/proxies/xapi/v1") ? tokens.getPlatformToken() : tokens.getCoreServicesToken();
        if (authorizationHeaderToken != null) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(authorizationHeaderToken, null);
            clientContext.getTargetAuthState().update((AuthScheme)new GatewayAuthScheme(), (Credentials)credentials);
        }
        context.setAttribute(ACCESS_TOKEN_KEY, (Object)tokens.getCoreServicesToken());
    }

    public void process(HttpResponse response, HttpContext context) {
        String accessTokenInUse = (String)context.getAttribute(ACCESS_TOKEN_KEY);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 403 || statusCode == 401) {
            this.tokenManager.resetIfEquals(accessTokenInUse);
        }
    }

    @Override
    public void reset() {
        this.tokenManager.reset();
    }

    public abstract String authenticate();

    String exchangeToken(String accessToken) {
        try {
            PortalAuthentication portalAuthentication = new PortalAuthentication();
            portalAuthentication.setToken(accessToken);
            portalAuthentication.setApiGatewayVersion(MuleManifest.getProductVersion());
            HttpResponse response = this.executePost(this.loginUrl, (HttpEntity)new StringEntity(this.objectMapper.writeValueAsString((Object)portalAuthentication), ContentType.APPLICATION_JSON));
            return this.processResponse(response, PortalAuthentication.class).getToken();
        }
        catch (JsonProcessingException e) {
            throw new EntityParsingException("Error building HTTP Request entity", (Exception)((Object)e));
        }
    }

    protected HttpResponse executePost(URI uri, HttpEntity entity) {
        try {
            HttpPost post = new HttpPost(uri);
            post.setEntity(entity);
            return this.client.execute((HttpUriRequest)post);
        }
        catch (IOException e) {
            throw new HttpConnectionException("An error occurred executing OAuth HTTP Request. " + ExceptionDescriptor.errorMessage((Throwable)e), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T processResponse(HttpResponse response, Class<T> clazz) {
        try (InputStream responseInputStream = response.getEntity().getContent();){
            if (response.getStatusLine().getStatusCode() != 200) {
                String message = response.getStatusLine().getStatusCode() != HttpConstants.HttpStatus.PROXY_AUTHENTICATION_REQUIRED.getStatusCode() ? "Authorization request to Anypoint Platform was not successful, client_id and/or client_secret may be wrong." : "Proxy authorization request failed, configured proxy username and/or password may be wrong.";
                throw new UnauthorizedException(message, IOUtils.toString((InputStream)responseInputStream), response.getStatusLine().getStatusCode());
            }
            T t = this.readResponseValue(response, clazz);
            return t;
        }
        catch (IOException e) {
            throw new HttpResponseException("An error occurred processing OAuth HTTP Response. " + ExceptionDescriptor.errorMessage((Throwable)e), e);
        }
    }

    protected <T> T readResponseValue(HttpResponse response, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(response.getEntity().getContent(), clazz);
        }
        catch (IOException e) {
            throw new EntityUnparsingException("Unable to parse HTTP Response content. " + ExceptionDescriptor.errorMessage((Throwable)e), e, response.getStatusLine().getStatusCode());
        }
    }
}

