/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.session;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.dto.ApiClientDto;
import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.client.response.PlatformResponse;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.client.session.metadata.ApiPlatformSessionMetadataBuilder;
import com.mulesoft.mule.runtime.gw.model.Api;
import java.util.List;

public class MonitoredApiPlatformSession
implements ApiPlatformSession {
    private final ApiPlatformClient client;
    private final ApiPlatformSessionMetadataBuilder metadata;

    public MonitoredApiPlatformSession(ApiPlatformClient client) {
        this.client = client;
        this.metadata = new ApiPlatformSessionMetadataBuilder();
    }

    @Override
    public SessionMetadata metadata() {
        return this.metadata.build();
    }

    @Override
    public ApiPlatformSession activateEndpoint(String organizationId, String environmentId, Long apiId) {
        try {
            PlatformResponse response = this.client.activateEndpoint(organizationId, environmentId, apiId);
            int statusCode = response.statusCode();
            this.metadata.response(statusCode);
        }
        catch (HttpResponseException e) {
            this.metadata.response(e.statusCode());
            throw e;
        }
        return this;
    }

    @Override
    public List<ApiClientDto> getApiClients(String organizationId, String environmentId, Long apiId) {
        try {
            PlatformResponse<List<ApiClientDto>> response = this.client.getApiClients(organizationId, environmentId, apiId);
            int statusCode = response.statusCode();
            this.metadata.response(statusCode);
            return response.entity();
        }
        catch (HttpResponseException e) {
            this.metadata.response(e.statusCode());
            throw e;
        }
    }

    @Override
    public ApiResponse getApi(Api api) {
        return this.getApi(api.getKey(), api.getTrackingInfo().getEntityTag());
    }

    @Override
    public ApiResponse getApi(ApiKey apiKey) {
        return this.getApi(apiKey, null);
    }

    @Override
    public ApiResponse getApi(ApiKey apiKey, String entityTag) {
        try {
            PlatformResponse<ApiResponse> response = this.client.getApi(apiKey, entityTag);
            int statusCode = response.statusCode();
            this.metadata.response(statusCode);
            return response.entity();
        }
        catch (HttpResponseException e) {
            this.metadata.response(e.statusCode());
            throw e;
        }
    }
}

