/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient.interceptors;

import static org.apache.http.util.EntityUtils.consumeQuietly;

import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.exception.NotFoundException;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;

public class HttpResponseStatusInterceptor implements HttpRequestResponseInterceptor {

  @Override
  public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
    // Do Nothing
  }

  @Override
  public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
    int statusCode = httpResponse.getStatusLine().getStatusCode();
    if (statusCode == 404) {
      consumePayload(httpResponse);
      throw new NotFoundException("Resource not found. Details: " + httpResponse.getStatusLine().getReasonPhrase());
    }

    // 401 should be treated different since we use it to retry.
    if ((statusCode < 200 || statusCode >= 400) && (statusCode != 401) && statusCode != 407) {
      consumePayload(httpResponse);
      throw new HttpResponseException("Server returned wrong status code: " + statusCode + ". Details: "
          + httpResponse.getStatusLine().getReasonPhrase(), statusCode);
    }
  }

  private void consumePayload(HttpResponse httpResponse) throws IOException {
    consumeQuietly(httpResponse.getEntity());
  }
}
