/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client;

import static com.fasterxml.jackson.databind.DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES;
import static com.fasterxml.jackson.databind.DeserializationFeature.READ_ENUMS_USING_TO_STRING;
import static com.fasterxml.jackson.databind.SerializationFeature.WRITE_ENUMS_USING_TO_STRING;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.mule.runtime.gw.client.dto.ApiDto;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.junit.Test;

public class ApiDtoParserTestCase {

  private static final ObjectMapper OBJECT_MAPPER =
      new ObjectMapper()
          .configure(FAIL_ON_UNKNOWN_PROPERTIES, false)
          .enable(READ_ENUMS_USING_TO_STRING)
          .enable(WRITE_ENUMS_USING_TO_STRING);

  private static final String MULTIPLE_CONFIG = "{  \n" +
      "   \"apiId\":94489,\n" +
      "   \"groupId\":\"b6f9702d-3143-4cac-8433-ea59ce0ee334\",\n" +
      "   \"assetId\":\"gw-simple-test-20171030\",\n" +
      "   \"version\":\"1.0.0\",\n" +
      "   \"productVersion\":\"v1\",\n" +
      "   \"autodiscoveryInstanceName\":\"v1:theversion\",\n" +
      "   \"exchangeAssetName\":\"GW-Simple-Test-20171030\",\n" +
      "   \"instanceLabel\":\"theversion\",\n" +
      "   \"environmentId\":\"9dba23d0-b1c6-4e16-b41e-55715cd655d4\",\n" +
      "   \"legacyApiIdentifier\":91738,\n" +
      "   \"endpointType\":\"http\",\n" +
      "   \"endpointUri\":null,\n" +
      "   \"proxyUri\":null,\n" +
      "   \"instanceName\":\"theversion\",\n" +
      "   \"policies\":[  \n" +
      "      {  \n" +
      "         \"policyTemplateId\":\"231\",\n" +
      "         \"order\":1,\n" +
      "         \"pointcutData\":null,\n" +
      "         \"policyId\":97566,\n" +
      "         \"configuration\":[  \n" +
      "            {  \n" +
      "               \"itemName\":\"Default Cond\",\n" +
      "               \"itemData\":{  \n" +
      "                  \"message\":\"#[attributes.headers['x-forwarded-for']]\",\n" +
      "                  \"conditional\":null,\n" +
      "                  \"level\":\"ERROR\",\n" +
      "                  \"firstSection\":false,\n" +
      "                  \"secondSection\":false,\n" +
      "                  \"thirdSection\":false,\n" +
      "                  \"forthSection\":false,\n" +
      "                  \"fifthSection\":true,\n" +
      "                  \"sixthSection\":true\n" +
      "               }\n" +
      "            }\n" +
      "         ],\n" +
      "         \"template\":{  \n" +
      "            \"groupId\":\"b6f9702d-3143-4cac-8433-ea59ce0ee334\",\n" +
      "            \"assetId\":\"message-logging\",\n" +
      "            \"assetVersion\":\"1.0.0-SNAPSHOT-20180122.53032\"\n" +
      "         },\n" +
      "         \"version\":1516650843788\n" +
      "      }\n" +
      "   ],\n" +
      "   \"lastModification\":1516651670673\n" +
      "}";

  private static final String SINGLE_CONFIG = "{  \n" +
      "   \"apiId\":94489,\n" +
      "   \"groupId\":\"b6f9702d-3143-4cac-8433-ea59ce0ee334\",\n" +
      "   \"assetId\":\"gw-simple-test-20171030\",\n" +
      "   \"version\":\"1.0.0\",\n" +
      "   \"productVersion\":\"v1\",\n" +
      "   \"autodiscoveryInstanceName\":\"v1:theversion\",\n" +
      "   \"exchangeAssetName\":\"GW-Simple-Test-20171030\",\n" +
      "   \"instanceLabel\":\"theversion\",\n" +
      "   \"environmentId\":\"9dba23d0-b1c6-4e16-b41e-55715cd655d4\",\n" +
      "   \"legacyApiIdentifier\":91738,\n" +
      "   \"endpointType\":\"http\",\n" +
      "   \"endpointUri\":null,\n" +
      "   \"proxyUri\":null,\n" +
      "   \"instanceName\":\"theversion\",\n" +
      "   \"policies\":[  \n" +
      "      {  \n" +
      "         \"policyTemplateId\":\"245\",\n" +
      "         \"order\":1,\n" +
      "         \"pointcutData\":null,\n" +
      "         \"policyId\":98162,\n" +
      "         \"configuration\":{  \n" +
      "            \"config\":\"configValue\",\n" +
      "            \"anotherConfig\":\"anotherConfigValue\"\n" +
      "         },\n" +
      "         \"template\":{  \n" +
      "            \"groupId\":\"68ef9520-24e9-4cf2-b2f5-620025690913\",\n" +
      "            \"assetId\":\"ip-whitelist\",\n" +
      "            \"assetVersion\":\"1.1.0-SNAPSHOT-20180123.90043\"\n" +
      "         },\n" +
      "         \"version\":1517249221923\n" +
      "      }\n" +
      "   ],\n" +
      "   \"lastModification\":1517336160695\n" +
      "}";


  @Test
  public void multipleConfiguration() throws IOException {
    ApiDto dto = OBJECT_MAPPER.readValue(MULTIPLE_CONFIG, ApiDto.class);
    assertThat(dto.getPolicies().get(0).getConfiguration().size(), is(1));

    Map<String, Object> configMap =
        ((List<Map<String, Object>>) dto.getPolicies().get(0).getConfiguration().get("configuration")).get(0);
    assertThat(configMap.size(), is(9));
    assertThat(configMap.get("message"), is("#[attributes.headers['x-forwarded-for']]"));
    assertThat(configMap.get("level"), is("ERROR"));
    assertThat(configMap.get("firstSection"), is(false));
    assertThat(configMap.get("secondSection"), is(false));
    assertThat(configMap.get("thirdSection"), is(false));
    assertThat(configMap.get("forthSection"), is(false));
    assertThat(configMap.get("fifthSection"), is(true));
    assertThat(configMap.get("sixthSection"), is(true));
  }

  @Test
  public void singleConfiguration() throws IOException {
    ApiDto dto = OBJECT_MAPPER.readValue(SINGLE_CONFIG, ApiDto.class);
    Map<String, Object> configMap = dto.getPolicies().get(0).getConfiguration();

    assertThat(configMap.size(), is(2));
    assertThat(configMap.get("config"), is("configValue"));
    assertThat(configMap.get("anotherConfig"), is("anotherConfigValue"));
  }
}
