/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.fail;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.RETURNS_DEEP_STUBS;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import com.mulesoft.mule.runtime.gw.client.mocks.CloseVerifiedInputStream;

import java.io.IOException;
import java.net.URISyntaxException;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.junit.Before;

public abstract class HttpClientTestCase {

  protected HttpClient httpClient;

  @Before
  public void setUp() throws URISyntaxException {
    this.httpClient = mock(HttpClient.class, RETURNS_DEEP_STUBS);
  }

  protected void httpClientExecuteReturns(int statusCode, CloseVerifiedInputStream payload) {
    try {
      HttpResponse response = response(statusCode, payload);
      when(httpClient.execute(any())).thenReturn(response);
    } catch (IOException e) {
      fail("Exception raised when trying to configure httpClient response: " + e.getMessage());
    }
  }

  protected HttpResponse response(int statusCode, CloseVerifiedInputStream payload) throws IOException {
    HttpResponse httpResponse = mock(HttpResponse.class, RETURNS_DEEP_STUBS);
    when(httpResponse.getEntity().getContent()).thenReturn(payload);
    when(httpResponse.getEntity().isStreaming()).thenReturn(true);
    when(httpResponse.getStatusLine().getStatusCode()).thenReturn(statusCode);
    return httpResponse;
  }

  protected CloseVerifiedInputStream invalidPayload() {
    return new CloseVerifiedInputStream("this is my invalid payload".getBytes());
  }

  protected CloseVerifiedInputStream emptyPayload() {
    return new CloseVerifiedInputStream("".getBytes());
  }

  protected void assertConsumed(CloseVerifiedInputStream payload) {
    assertConsumed(payload, "");
  }

  protected void assertConsumed(CloseVerifiedInputStream payload, String loggingPrefix) {
    assertThat(loggingPrefix + " Stream should have been closed", payload.wasClosed(), is(true));
  }

  protected void assertNotConsumed(CloseVerifiedInputStream payload, String loggingPrefix) {
    assertThat(loggingPrefix + " Payload should not have been consumed", payload.available(), greaterThan(0));
    assertThat(loggingPrefix + " Stream should not have been closed", payload.wasClosed(), is(false));
  }
}
