/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.session;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static org.hamcrest.core.Is.is;
import static org.mule.runtime.core.api.util.IOUtils.getResourceAsUrl;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.client.exception.EntityUnparsingException;
import com.mulesoft.mule.runtime.gw.client.exception.NotFoundException;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;

import java.io.File;
import java.net.URISyntaxException;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class FileSystemPlatformSessionTestCase {

  private File apiDirectory;

  @Rule
  public ExpectedException thrown = ExpectedException.none();

  public FileSystemPlatformSessionTestCase() throws URISyntaxException {
    apiDirectory = new File(getResourceAsUrl("api-directory", this.getClass()).toURI());
  }

  @Test
  public void apiReadCorrectly() {
    ApiPlatformSession session = new FileSystemPlatformSession(apiDirectory);

    ApiResponse response = session.getApi(new ApiKey(640317L));

    assertThat(response.getTrackingInfo().getId(), is(640317L));
    assertThat(response.getSlas(), hasSize(2));
    assertThat(response.getPolicySet().getPolicyDefinitions(), hasSize(4));
  }

  @Test
  public void notFoundAPi() {
    ApiPlatformSession session = new FileSystemPlatformSession(apiDirectory);

    thrown.expect(NotFoundException.class);

    session.getApi(new ApiKey(640318L));
  }

  @Test
  public void invalidJson() {
    ApiPlatformSession session = new FileSystemPlatformSession(apiDirectory);

    thrown.expect(EntityUnparsingException.class);

    session.getApi(new ApiKey(640319L));
  }

  @Test
  public void emptyFolder() {
    ApiPlatformSession session = new FileSystemPlatformSession(new File("foo"));

    thrown.expect(RuntimeException.class);
    thrown.expectMessage("Could not find api information folder, check that it is correctly configured.");

    session.getApi(new ApiKey(640319L));
  }

}
