/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.dto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;

@JsonAutoDetect
public class LimitDto {

  protected int maximumRequests;
  protected long timePeriodInMilliseconds;

  public LimitDto() {}

  public LimitDto(int maximumRequests, long timePeriodInMilliseconds) {
    this.maximumRequests = maximumRequests;
    this.timePeriodInMilliseconds = timePeriodInMilliseconds;
  }

  public long getTimePeriodInMilliseconds() {
    return timePeriodInMilliseconds;
  }

  public void setTimePeriodInMilliseconds(long timePeriodInMilliseconds) {
    this.timePeriodInMilliseconds = timePeriodInMilliseconds;
  }

  public int getMaximumRequests() {
    return maximumRequests;
  }

  public void setMaximumRequests(int maximumRequests) {
    this.maximumRequests = maximumRequests;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    LimitDto limitDto = (LimitDto) o;

    if (maximumRequests != limitDto.maximumRequests) {
      return false;
    }
    return timePeriodInMilliseconds == limitDto.timePeriodInMilliseconds;
  }

  @Override
  public int hashCode() {
    int result = maximumRequests;
    result = 31 * result + (int) (timePeriodInMilliseconds ^ (timePeriodInMilliseconds >>> 32));
    return result;
  }
}
