/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.exception;

import org.slf4j.Logger;
import static com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor.errorMessage;

public abstract class AbstractNormalizedExceptionMessageLogger implements NormalizedExceptionMessageLogger {

  protected abstract String errorMessageString();

  protected abstract String errorMessageWithParameter();

  private static final String DEBUG_INFO_MESSAGE = "Logging full throwable.";

  private final Logger logger;

  public AbstractNormalizedExceptionMessageLogger(Logger logger) {
    this.logger = logger;
  }

  @Override
  public void warn(String failedActionDescription, Throwable e) {
    logger.warn(errorMessageString(), failedActionDescription, errorMessage(e));
    debugInfo(e);
  }

  @Override
  public void warn(String failedActionDescription, Object parameter, Throwable e) {
    logger.warn(errorMessageWithParameter(), failedActionDescription, parameter, errorMessage(e));
    debugInfo(e);
  }

  @Override
  public void error(String failedActionDescription, Throwable e) {
    logger.error(errorMessageString(), failedActionDescription, errorMessage(e));
    debugInfo(e);
  }

  @Override
  public void error(String failedActionDescription, Object parameter, Throwable e) {
    logger.error(errorMessageWithParameter(), failedActionDescription, parameter, errorMessage(e));
    debugInfo(e);
  }

  private void debugInfo(Throwable e) {
    logger.debug(DEBUG_INFO_MESSAGE, e);
  }

}
