/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient.interceptors;

import static org.mule.runtime.http.api.HttpHeaders.Names.AUTHORIZATION;

import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;

public class GatewayAuthScheme extends AuthSchemeBase {

  @Override
  public String getSchemeName() {
    return "API Gateway client auth";
  }

  @Override
  public String getParameter(String name) {
    return null;
  }

  @Override
  public String getRealm() {
    return null;
  }

  @Override
  public boolean isConnectionBased() {
    return false;
  }

  @Override
  public boolean isComplete() {
    return false;
  }

  @Override
  public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
    return authenticate(credentials, request, null);
  }

  @Override
  public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context)
      throws AuthenticationException {

    return new BasicHeader(AUTHORIZATION, "Bearer " + credentials.getUserPrincipal().getName());
  }

  @Override
  protected void parseChallenge(CharArrayBuffer buffer, int beginIndex, int endIndex)
      throws MalformedChallengeException {

  }
}
