/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.model;

import com.mulesoft.mule.runtime.gw.client.ApiPlatformSourceTypeEnum;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;


@JsonAutoDetect
@JsonIgnoreProperties({"organizationId", "lastSeen", "audit", "lastActiveDate"})
public class ApiEndpoint {

  @JsonInclude(value = JsonInclude.Include.NON_NULL)
  private Integer id;
  @JsonProperty("type")
  private String type;
  @JsonProperty("uri")
  private String uri;
  @JsonProperty("apiVersionId")
  private Integer apiVersionId;

  public ApiEndpoint() {}

  public ApiEndpoint(Integer id, ApiPlatformSourceTypeEnum type, String uri, Integer apiVersionId) {
    this(type, uri, apiVersionId);
    this.id = id;
  }

  public ApiEndpoint(ApiPlatformSourceTypeEnum type, String uri, Integer apiVersionId) {
    this.type = type.getName();
    this.uri = uri;
    this.apiVersionId = apiVersionId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getUri() {
    return uri;
  }

  public void setUri(String uri) {
    this.uri = uri;
  }

  public int getApiVersionId() {
    return apiVersionId;
  }

  public void setApiVersionId(Integer apiVersionId) {
    this.apiVersionId = apiVersionId;
  }

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

}
