/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonAutoDetect
@JsonIgnoreProperties({"email", "firstName", "lastName", "username", "isAnonymous"})
public class PortalAuthentication {

  @JsonProperty("token")
  private String token;

  @JsonProperty("apiGatewayVersion")
  private String apiGatewayVersion;

  public String getToken() {
    return token;
  }

  public void setToken(String token) {
    this.token = token;
  }

  public String getApiGatewayVersion() {
    return apiGatewayVersion;
  }

  public void setApiGatewayVersion(String apiGatewayVersion) {
    this.apiGatewayVersion = apiGatewayVersion;
  }
}

