/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.exception;

/**
 * Particular {@link HttpResponseException} that signals that an attempt to authenticate was not successful
 */
public class UnauthorizedException extends HttpResponseException {

  private static final long serialVersionUID = 5053493343086454559L;

  public UnauthorizedException(String msg, String payload, int statusCode) {
    super(msg + "\nStatus code: " + statusCode + "\nServer Payload:\n" + payload, statusCode);
  }
}
