/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.session;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.model.ApiClientsResponse;
import com.mulesoft.mule.runtime.gw.client.response.PlatformResponse;
import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.client.session.metadata.ApiPlatformSessionMetadataBuilder;
import com.mulesoft.mule.runtime.gw.model.Api;

//TODO AGW-1561: Make Platform Session return Gateway's model objects
public class MonitoredApiPlatformSession implements ApiPlatformSession {

  private final ApiPlatformClient client;
  private final ApiPlatformSessionMetadataBuilder metadata;

  public MonitoredApiPlatformSession(ApiPlatformClient client) {
    this.client = client;
    this.metadata = new ApiPlatformSessionMetadataBuilder();
  }

  @Override
  public SessionMetadata metadata() {
    return metadata.build();
  }

  @Override // TODO AGW-1561: remove throws, wrap metadata.request/response and call into a method with lambda.
  public ApiPlatformSession activateEndpoint(String organizationId, String environmentId, Long apiId) {
    try {
      PlatformResponse response = client.activateEndpoint(organizationId, environmentId, apiId);
      int statusCode = response.statusCode();
      metadata.response(statusCode);
    } catch (HttpResponseException e) {
      metadata.response(e.statusCode());
      throw e;
    }

    return this;
  }

  @Override // TODO AGW-1561: remove throws, rename inner methods.
  public ApiClientsResponse getApiClients(String organizationId, String environmentId, Long apiId) {
    return getApiClients(organizationId, environmentId, apiId, null);
  }

  @Override
  public ApiClientsResponse getApiClients(String organizationId, String environmentId, Long apiId, String contractsEntityTag) {
    try {
      PlatformResponse<ApiClientsResponse> response =
          client.getApiClients(organizationId, environmentId, apiId, contractsEntityTag);
      int statusCode = response.statusCode();
      metadata.response(statusCode);

      return response.entity();
    } catch (HttpResponseException e) {
      metadata.response(e.statusCode());
      throw e;
    }
  }

  @Override
  public ApiResponse getApi(Api api) {
    return getApi(api.getKey(), api.getTrackingInfo().getApiEntityTag());
  }

  @Override
  public ApiResponse getApi(ApiKey apiKey) {
    return getApi(apiKey, null);
  }

  @Override
  public ApiResponse getApi(ApiKey apiKey, String apiEntityTag) {
    try {
      PlatformResponse<ApiResponse> response = client.getApi(apiKey, apiEntityTag);
      int statusCode = response.statusCode();
      metadata.response(statusCode);

      return response.entity();
    } catch (HttpResponseException e) {
      metadata.response(e.statusCode());
      throw e;
    }
  }
}
