/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.dto;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;

@JsonAutoDetect
@JsonInclude(value = NON_NULL)
public class ApiDto {

  @JsonProperty("apiId")
  private Long id;

  @JsonProperty("instanceName")
  private String instanceName;

  @JsonProperty("autodiscoveryInstanceName")
  private String autodiscoveryInstanceName;

  @JsonProperty("productVersion")
  private String productVersion;

  @JsonProperty("groupId")
  private String groupId;

  @JsonProperty("assetId")
  private String assetId;

  @JsonProperty("exchangeAssetName")
  private String exchangeAssetName;

  @JsonProperty("version")
  private String version;

  @JsonProperty("organizationId")
  private String organizationId;

  @JsonProperty("environmentId")
  private String environmentId;

  @JsonProperty("endpointType")
  private String endpointType;

  @JsonProperty("legacyApiIdentifier")
  private Integer legacyApiIdentifier;

  @JsonProperty("policies")
  private List<PolicyDefinitionDto> policies;

  @JsonProperty("identityManagement")
  private IdentityManagementDto identityManagement;

  @JsonProperty("tiers")
  private SlaWrapperDto tiers;

  public ApiDto() {}

  public ApiDto(Long id, String instanceName, String version, String organizationId, String environmentId,
                List<SlaDto> tiers, List<PolicyDefinitionDto> policies, String exchangeAssetName) {
    this.id = id;
    this.instanceName = instanceName;
    this.version = version;
    this.organizationId = organizationId;
    this.environmentId = environmentId;
    this.tiers = new SlaWrapperDto(tiers);
    this.policies = policies;
    this.exchangeAssetName = exchangeAssetName;
  }

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public String getInstanceName() {
    return instanceName;
  }

  public void setInstanceName(String instanceName) {
    this.instanceName = instanceName;
  }

  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  public String getAssetId() {
    return assetId;
  }

  public void setAssetId(String assetId) {
    this.assetId = assetId;
  }

  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public Integer getLegacyApiIdentifier() {
    return legacyApiIdentifier;
  }

  public void setLegacyApiIdentifier(int legacyApiIdentifier) {
    this.legacyApiIdentifier = legacyApiIdentifier;
  }

  public List<PolicyDefinitionDto> getPolicies() {
    return policies;
  }

  public void setPolicies(List<PolicyDefinitionDto> policies) {
    this.policies = policies;
  }

  public String getOrganizationId() {
    return organizationId;
  }

  public void setOrganizationId(String organizationId) {
    this.organizationId = organizationId;
  }

  public String getEnvironmentId() {
    return environmentId;
  }

  public void setEnvironmentId(String environmentId) {
    this.environmentId = environmentId;
  }

  public String getEndpointType() {
    return endpointType;
  }

  public void setEndpointType(String endpointType) {
    this.endpointType = endpointType;
  }

  public List<SlaDto> getTiers() {
    return tiers != null ? tiers.getValues() : new ArrayList<>();
  }

  public String getProductVersion() {
    return productVersion;
  }

  public void setProductVersion(String productVersion) {
    this.productVersion = productVersion;
  }

  public IdentityManagementDto getIdentityManagement() {
    return identityManagement;
  }

  public void setIdentityManagement(IdentityManagementDto identityManagement) {
    this.identityManagement = identityManagement;
  }

  public String getAutodiscoveryInstanceName() {
    return autodiscoveryInstanceName;
  }

  public void setAutodiscoveryInstanceName(String autodiscoveryInstanceName) {
    this.autodiscoveryInstanceName = autodiscoveryInstanceName;
  }

  public String getExchangeAssetName() {
    return exchangeAssetName;
  }

  public void setExchangeAssetName(String exchangeAssetName) {
    this.exchangeAssetName = exchangeAssetName;
  }
}
