/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.dto;

import static com.google.common.collect.ImmutableMap.of;
import static java.util.Arrays.asList;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PolicyConfigurationDeserializer extends StdDeserializer {

  public PolicyConfigurationDeserializer() {
    super(PolicyDefinitionDto.class);
  }

  @Override
  public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext)
      throws IOException {
    ObjectMapper mapper = getObjectMapper(jsonParser);
    JsonNode node = getNode(jsonParser);
    if (node.isArray()) {
      List<ConfigurationDto> configurationDtos = asList(mapper.treeToValue(node, ConfigurationDto[].class));
      List<Map<String, Object>> configurations = new ArrayList<>();
      configurationDtos.forEach(dto -> configurations.add(dto.getItemData()));
      return of("configuration", configurations);
    }
    return mapper.convertValue(node, Map.class);
  }

  private JsonNode getNode(JsonParser jsonParser) throws IOException {
    return getObjectMapper(jsonParser).readTree(jsonParser);
  }

  private ObjectMapper getObjectMapper(JsonParser jsonParser) {
    return (ObjectMapper) jsonParser.getCodec();
  }
}
