/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient.interceptors;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;

public class BenchmarkInterceptor implements HttpRequestResponseInterceptor {

  private static final String START_TIME_ATTRIBUTE = "BenchmarkInterceptor.START_TIME";
  private static final String REQUEST_INFO_ATTRIBUTE = "BenchmarkInterceptor.REQUEST_INFO";

  private final Logger logger;

  public BenchmarkInterceptor(Logger logger) {
    this.logger = logger;
  }

  @Override
  public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
    if (logger.isDebugEnabled()) {
      httpContext.setAttribute(REQUEST_INFO_ATTRIBUTE,
                               httpRequest.getRequestLine().getMethod() + " " + httpRequest.getRequestLine().getUri());
      httpContext.setAttribute(START_TIME_ATTRIBUTE, System.currentTimeMillis());
    }
  }

  @Override
  public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
    Long startTime = (Long) httpContext.getAttribute(START_TIME_ATTRIBUTE);
    if (logger.isDebugEnabled() && startTime != null) {
      long elapsed = System.currentTimeMillis() - startTime;

      logger.debug(
                   httpContext.getAttribute(REQUEST_INFO_ATTRIBUTE) + " " + httpResponse.getStatusLine().getStatusCode() + " "
                       + "(took " + elapsed + "ms)");
    }
  }
}
