/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.model;

import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolation;
import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolationOutcome;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;

import java.io.Serializable;

@JsonAutoDetect
public class PolicyViolationDto implements Serializable {

  private static final long serialVersionUID = -3999208245432970402L;

  @JsonProperty("policy_id")
  private String policyId;

  @JsonProperty("outcome")
  private PolicyViolationOutcome outcome;

  @JsonProperty("policy_name")
  @JsonView(HttpEventViews.ExternalAnalytics.class)
  private String policyName;

  public PolicyViolationDto(String policyId, PolicyViolationOutcome outcome, String policyName) {
    this.policyId = policyId;
    this.outcome = outcome;
    this.policyName = policyName;
  }

  public static PolicyViolationDto from(PolicyViolation policyViolation) {
    return new PolicyViolationDto(policyViolation.getPolicyId(), policyViolation.getOutcome(), policyViolation.getPolicyName());
  }

  public String getPolicyId() {
    return policyId;
  }

  public PolicyViolationOutcome getOutcome() {
    return outcome;
  }

  public String getPolicyName() {
    return this.policyName;
  }

  @Override
  public String toString() {
    return "{" + "outcome=" + outcome + ", policyId=" + policyId + '}';
  }

}
