/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.session.factory;

import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.client.session.MonitoredApiPlatformSession;

public class RestClientApiPlatformSessionFactory implements ApiPlatformSessionFactory {

  private final ApiPlatformClient client;

  public RestClientApiPlatformSessionFactory(ApiPlatformClient client) {
    this.client = client;
  }

  @Override
  public ApiPlatformSession create() {
    client.cleanConnections();
    return new MonitoredApiPlatformSession(client);
  }
}
