/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.dto;

import static java.util.Collections.emptyMap;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import java.util.List;
import java.util.Map;

@JsonAutoDetect
public class PolicyDefinitionDto {

  @JsonProperty("policyId")
  private String id;

  @JsonProperty("template")
  private PolicyTemplateKeyDto policyTemplateKey;

  @JsonProperty("order")
  private int order;

  @JsonProperty("pointcutData")
  private List<PointcutDataDto> pointcutData;

  @JsonProperty("configuration")
  @JsonDeserialize(using = PolicyConfigurationDeserializer.class)
  private Map<String, Object> configuration;

  @JsonProperty("version")
  private String version;

  @JsonProperty("violationCategory")
  private String violationCategory;

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public PolicyTemplateKeyDto getPolicyTemplateKey() {
    return policyTemplateKey;
  }

  public void setPolicyTemplateKey(PolicyTemplateKeyDto templateKey) {
    this.policyTemplateKey = templateKey;
  }

  public Map<String, Object> getConfiguration() {
    return configuration != null ? configuration : emptyMap();
  }

  public void setConfiguration(Map<String, Object> configuration) {
    this.configuration = configuration;
  }

  public int getOrder() {
    return order;
  }

  public void setOrder(int order) {
    this.order = order;
  }

  public List<PointcutDataDto> getPointcutData() {
    return pointcutData;
  }

  public void setPointcutData(List<PointcutDataDto> pointcutData) {
    this.pointcutData = pointcutData;
  }

  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public void setViolationCategory(String violationCategory) {
    this.violationCategory = violationCategory;
  }

  public String getViolationCategory() {
    return violationCategory;
  }
}
