/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.exception;

import static org.mule.runtime.http.api.HttpConstants.HttpStatus.SERVICE_UNAVAILABLE;

/**
 * Exception thrown when an error happens while executing an HTTP request
 */
public class HttpResponseException extends RuntimeException {

  private static final long serialVersionUID = 5681413643498454226L;
  private int status;

  public HttpResponseException(String msg) {
    this(msg, SERVICE_UNAVAILABLE.getStatusCode());
  }

  public HttpResponseException(String msg, int status) {
    super(msg);
    this.status = status;
  }

  public HttpResponseException(String msg, Exception e) {
    this(msg, e, SERVICE_UNAVAILABLE.getStatusCode());
  }

  public HttpResponseException(String msg, Exception e, int status) {
    super(msg, e);
    this.status = status;
  }

  public int statusCode() {
    return status;
  }

}
