/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.adapter;

import com.mulesoft.mule.runtime.gw.client.dto.ApiClientDto;
import com.mulesoft.mule.runtime.gw.client.model.ApiClientsResponse;

import java.util.List;

public class ApiClientsResponseBuilder {

  private List<ApiClientDto> clients;
  private String contractsEntityTag;
  private boolean noUpdates;

  public ApiClientsResponseBuilder noUpdates() {
    this.noUpdates = true;
    return this;
  }

  public ApiClientsResponseBuilder withClients(List<ApiClientDto> clients) {
    this.clients = clients;
    return this;
  }

  public ApiClientsResponseBuilder withContractsEntityTag(String entityTag) {
    this.contractsEntityTag = entityTag;
    return this;
  }

  public ApiClientsResponse build() {
    return noUpdates ? new ApiClientsResponse(null, null, false) : new ApiClientsResponse(contractsEntityTag, clients, true);
  }

}
