/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.dto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;

import java.util.ArrayList;
import java.util.List;

@JsonAutoDetect
public class SlaDto {

  private Integer id;
  private List<LimitDto> limits;

  public SlaDto() {
    limits = new ArrayList<>();
  }

  public SlaDto(int id, List<LimitDto> limits) {
    this();
    this.id = id;
    this.limits = limits;
  }

  public List<LimitDto> getLimits() {
    return limits;
  }

  public void setLimits(List<LimitDto> limits) {
    this.limits = limits;
  }

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    SlaDto slaDto = (SlaDto) o;

    if (!id.equals(slaDto.id)) {
      return false;
    }
    return limits.equals(slaDto.limits);
  }

  @Override
  public int hashCode() {
    int result = id.hashCode();
    result = 31 * result + limits.hashCode();
    return result;
  }
}
