/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.exception;

import static org.mule.runtime.http.api.HttpConstants.HttpStatus.NOT_FOUND;

/**
 * Particular {@link HttpResponseException} that signals that the HTTP request ended with a NOT FOUND status
 */
public class NotFoundException extends HttpResponseException {

  private static final long serialVersionUID = 6231644110639677434L;

  public NotFoundException(String msg) {
    super(msg, NOT_FOUND.getStatusCode());
  }
}
