/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient.interceptors;

import static com.mulesoft.mule.runtime.gw.api.time.DateTime.now;

import com.mulesoft.mule.runtime.gw.api.time.DateTime;

public class AccessTokens {

  private final String coreServicesToken;
  private final String platformToken;

  private final DateTime expires;

  AccessTokens(String coreServicesToken, String platformAccessToken, DateTime secondsToExpiration) {
    this.coreServicesToken = coreServicesToken;
    this.platformToken = platformAccessToken;
    this.expires = secondsToExpiration;
  }

  AccessTokens(String coreServicesToken) {
    this(coreServicesToken, null, null);
  }

  public static AccessTokens invalidTokens() {
    return new AccessTokens(null, null, null);
  }

  public String getCoreServicesToken() {
    return coreServicesToken;
  }

  public String getPlatformToken() {
    return platformToken;
  }

  public DateTime getExpirationTime() {
    return expires;
  }

  public boolean haveExpired() {
    return (expires != null) && now().isAfter(expires);
  }
}
