/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient.interceptors;

import static java.lang.String.format;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;
import static org.mockito.Mockito.mock;
import static org.mule.runtime.core.api.config.MuleManifest.getProductVersion;

import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;

import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.protocol.HttpContext;
import org.junit.Before;
import org.junit.Test;

public class UserAgentEnricherInterceptorTestCase {

  private HttpContext httpContext;
  private UserAgentEnricherInterceptor interceptor;

  @Before
  public void setUp() throws URISyntaxException {
    this.httpContext = mock(HttpContext.class);
    this.interceptor = new UserAgentEnricherInterceptor();
  }

  @Test
  public void addsAgentHeader() throws Exception {
    HttpRequest request = new HttpGet("http://localhost:8080/placeholder");
    interceptor.process(request, httpContext);
    assertThat(request.getFirstHeader("User-Agent").getValue(), is(desiredUserAgentHeaderValue()));
  }

  @Test
  public void replacesAgentHeader() throws Exception {
    HttpRequest request = new HttpGet("http://localhost:8080/placeholder");
    request.addHeader("User-Agent", "foo");
    interceptor.process(request, httpContext);
    assertThat(request.getHeaders("User-Agent").length, is(1));
    assertThat(request.getFirstHeader("User-Agent").getValue(), is(desiredUserAgentHeaderValue()));
  }

  @Test
  public void replacesAgentHeaderWithDifferentCase() throws Exception {
    HttpRequest request = new HttpGet("http://localhost:8080/placeholder");
    request.addHeader("user-Agent", "foo");
    interceptor.process(request, httpContext);
    assertThat(request.getHeaders("user-Agent").length, is(1));
    assertThat(request.getFirstHeader("user-Agent").getValue(), is(desiredUserAgentHeaderValue()));
  }

  @Test
  public void replaceOnlyFirstHeader() throws Exception {
    HttpRequest request = new HttpGet("http://localhost:8080/placeholder");
    request.addHeader("User-Agent", "foo");
    request.addHeader("User-Agent", "bar");
    interceptor.process(request, httpContext);
    assertThat(request.getHeaders("user-Agent").length, is(2));
    assertThat(request.getHeaders("User-Agent")[0].getValue(), is(desiredUserAgentHeaderValue()));
    assertThat(request.getHeaders("User-Agent")[1].getValue(), is("bar"));
  }

  public String desiredUserAgentHeaderValue() throws UnknownHostException {
    return format("API Gateway %s (Java/%s) (%s)",
                  getProductVersion(), System.getProperty("java.version"), InetAddress.getLocalHost().getHostName());
  }

}
