/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.exception;

import org.slf4j.Logger;

public class NonRecoverableExceptionMessageLogger extends AbstractNormalizedExceptionMessageLogger {

  public NonRecoverableExceptionMessageLogger(Logger logger) {
    super(logger);
  }

  private static final String ERROR_MESSAGE = "Failed to {}. {}";
  private static final String ERROR_MESSAGE_WITH_PARAMETER = "Failed to {} '{}'. {}";

  @Override
  protected String errorMessageString() {
    return ERROR_MESSAGE;
  }

  @Override
  protected String errorMessageWithParameter() {
    return ERROR_MESSAGE_WITH_PARAMETER;
  }
}
