/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.model;

import com.mulesoft.mule.runtime.gw.client.dto.ApiClientDto;

import java.util.List;

public class ApiClientsResponse {

  private final String contractsEntityTag;
  private final List<ApiClientDto> clients;
  private final Boolean hasUpdates;

  public ApiClientsResponse(String contractsEntityTag, List<ApiClientDto> clients, boolean hasUpdates) {
    this.contractsEntityTag = contractsEntityTag;
    this.clients = clients;
    this.hasUpdates = hasUpdates;
  }

  public Boolean hasUpdates() {
    return hasUpdates;
  }

  public List<ApiClientDto> getClients() {
    return clients;
  }

  public String getContractsEntityTag() {
    return contractsEntityTag;
  }
}
