/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client.session;

import static com.fasterxml.jackson.databind.DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES;
import static com.fasterxml.jackson.databind.DeserializationFeature.READ_ENUMS_USING_TO_STRING;
import static com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor.errorMessage;
import static java.lang.String.format;
import static java.util.Collections.emptyList;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.client.adapter.ApiClientsResponseBuilder;
import com.mulesoft.mule.runtime.gw.client.adapter.ApiResponseBuilder;
import com.mulesoft.mule.runtime.gw.client.dto.ApiDto;
import com.mulesoft.mule.runtime.gw.client.exception.EntityUnparsingException;
import com.mulesoft.mule.runtime.gw.client.exception.NotFoundException;
import com.mulesoft.mule.runtime.gw.client.model.ApiClientsResponse;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.model.Api;

import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.File;
import java.io.IOException;

import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class FileSystemPlatformSession implements ApiPlatformSession {

  private final File apiDirectory;
  private final ObjectMapper objectMapper;

  public FileSystemPlatformSession(File apiDirectory) {
    this.apiDirectory = apiDirectory;
    this.objectMapper = new ObjectMapper()
        .configure(FAIL_ON_UNKNOWN_PROPERTIES, false)
        .enable(READ_ENUMS_USING_TO_STRING);
  }

  @Override
  public SessionMetadata metadata() {
    throw new NotImplementedException();
  }

  public ApiPlatformSession activateEndpoint(String organizationId, String environmentId, Long apiId) {
    return this;
  }

  @Override
  public ApiClientsResponse getApiClients(String organizationId, String environmentId, Long apiId) {
    return getApiClients(organizationId, environmentId, apiId, null);
  }

  @Override
  public ApiClientsResponse getApiClients(String organizationId, String environmentId, Long apiId, String contractsEntityTag) {
    return new ApiClientsResponseBuilder()
        .withClients(emptyList())
        .build();
  }

  @Override
  public ApiResponse getApi(Api api) {
    return getApi(api.getKey());
  }

  @Override
  public ApiResponse getApi(ApiKey apiKey) {
    return getApi(apiKey, null);
  }

  @Override
  public ApiResponse getApi(ApiKey apiKey, String apiEntityTag) {
    return new ApiResponseBuilder()
        .withApi(parseEntity(getApiFile(apiKey), ApiDto.class))
        .build();
  }

  private File getApiFile(ApiKey apiKey) {
    File apiFile = new File(getApiDirectory(), getApiFileName(apiKey));
    if (!apiFile.exists() || !apiFile.isFile()) {
      throw new NotFoundException(format("Could not find information for api %s", apiKey.id()));
    }
    return apiFile;
  }

  private File getApiDirectory() {
    if (!apiDirectory.exists() || !apiDirectory.isDirectory()) {
      throw new RuntimeException("Could not find api information folder, check that it is correctly configured.");
    }
    return apiDirectory;
  }

  private String getApiFileName(ApiKey apiKey) {
    return format("%s.json", apiKey.id());
  }

  private <T> T parseEntity(File response, Class<T> valueType) {
    try {
      return objectMapper.readValue(response, valueType);
    } catch (IOException e) {
      throw new EntityUnparsingException("Unable to parse HTTP Response content. " + errorMessage(e), e);
    }
  }

}
